/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.routing;

import io.scalecube.services.ServiceReference;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.registry.api.ServiceRegistry;
import io.scalecube.services.routing.Router;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.jctools.maps.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinServiceRouter
implements Router {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoundRobinServiceRouter.class);
    private final Map<String, AtomicInteger> counterByServiceName = new NonBlockingHashMap<String, AtomicInteger>();

    @Override
    public Optional<ServiceReference> route(ServiceRegistry serviceRegistry, ServiceMessage request) {
        List<ServiceReference> serviceInstances = serviceRegistry.lookupService(request.qualifier());
        if (serviceInstances.size() > 1) {
            AtomicInteger counter = this.counterByServiceName.computeIfAbsent(request.qualifier(), or -> new AtomicInteger());
            int index = (counter.incrementAndGet() & Integer.MAX_VALUE) % serviceInstances.size();
            return Optional.of(serviceInstances.get(index));
        }
        if (serviceInstances.size() == 1) {
            return Optional.of(serviceInstances.get(0));
        }
        LOGGER.warn("route selection return null since no service instance was found for {}", (Object)request.qualifier());
        return Optional.empty();
    }
}

