/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.registry.api;

import io.scalecube.services.ServiceEndpoint;

public class RegistrationEvent {
    private final ServiceEndpoint serviceEndpoint;
    private final Type type;

    private RegistrationEvent(Type type, ServiceEndpoint serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        this.type = type;
    }

    public static RegistrationEvent registered(ServiceEndpoint serviceEndpoint) {
        return new RegistrationEvent(Type.REGISTERED, serviceEndpoint);
    }

    public static RegistrationEvent unregistered(ServiceEndpoint serviceEndpoint) {
        return new RegistrationEvent(Type.UNREGISTERED, serviceEndpoint);
    }

    public ServiceEndpoint serviceEndpoint() {
        return this.serviceEndpoint;
    }

    public Type type() {
        return this.type;
    }

    public String toString() {
        return "RegistrationEvent [serviceEndpoint=" + this.serviceEndpoint + ", type=" + (Object)((Object)this.type) + "]";
    }

    public static enum Type {
        REGISTERED,
        UNREGISTERED;

    }
}

