/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.registry;

import io.scalecube.services.ServiceEndpoint;
import io.scalecube.services.ServiceMethodDefinition;
import io.scalecube.services.ServiceReference;
import io.scalecube.services.ServiceRegistration;
import io.scalecube.services.registry.api.RegistrationEvent;
import io.scalecube.services.registry.api.ServiceRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jctools.maps.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ServiceRegistryImpl
implements ServiceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRegistryImpl.class);
    private final DirectProcessor<RegistrationEvent> subject = DirectProcessor.create();
    private final Map<String, ServiceEndpoint> serviceEndpoints = new NonBlockingHashMap<String, ServiceEndpoint>();
    private final Map<String, List<ServiceReference>> referencesByQualifier = new NonBlockingHashMap<String, List<ServiceReference>>();

    @Override
    public List<ServiceEndpoint> listServiceEndpoints() {
        return new ArrayList<ServiceEndpoint>(this.serviceEndpoints.values());
    }

    @Override
    public List<ServiceReference> listServiceReferences() {
        return this.serviceReferenceStream().collect(Collectors.toList());
    }

    @Override
    public List<ServiceReference> lookupService(String qualifier) {
        List<ServiceReference> result = this.referencesByQualifier.get(qualifier);
        return result != null ? Collections.unmodifiableList(result) : Collections.emptyList();
    }

    @Override
    public List<ServiceReference> lookupService(Predicate<? super ServiceReference> filter) {
        Stream<ServiceReference> stream = this.serviceReferenceStream();
        if (filter != null) {
            stream = stream.filter(filter);
        }
        return stream.collect(Collectors.toList());
    }

    @Override
    public boolean registerService(ServiceEndpoint serviceEndpoint) {
        boolean success;
        boolean bl = success = this.serviceEndpoints.putIfAbsent(serviceEndpoint.id(), serviceEndpoint) == null;
        if (success) {
            serviceEndpoint.serviceRegistrations().stream().flatMap(serviceRegistration -> serviceRegistration.methods().stream().map(sm -> new ServiceReference((ServiceMethodDefinition)sm, (ServiceRegistration)serviceRegistration, serviceEndpoint))).forEach(serviceReference -> this.referencesByQualifier.computeIfAbsent(serviceReference.qualifier(), key -> new CopyOnWriteArrayList()).add(serviceReference));
            RegistrationEvent registrationEvent = RegistrationEvent.registered(serviceEndpoint);
            LOGGER.debug("Publish registered: " + registrationEvent);
            this.subject.onNext(registrationEvent);
        }
        return success;
    }

    @Override
    public ServiceEndpoint unregisterService(String endpointId) {
        ServiceEndpoint serviceEndpoint = this.serviceEndpoints.remove(endpointId);
        if (serviceEndpoint != null) {
            this.referencesByQualifier.values().forEach(list -> list.removeIf(sr -> sr.endpointId().equals(endpointId)));
            RegistrationEvent registrationEvent = RegistrationEvent.unregistered(serviceEndpoint);
            LOGGER.debug("Publish unregistered: " + registrationEvent);
            this.subject.onNext(registrationEvent);
        }
        return serviceEndpoint;
    }

    @Override
    public Flux<RegistrationEvent> listen() {
        return Flux.fromStream(this.serviceEndpoints.values().stream()).map(RegistrationEvent::registered).concatWith(this.subject);
    }

    Stream<ServiceReference> serviceReferenceStream() {
        return this.referencesByQualifier.values().stream().flatMap(Collection::stream);
    }

    @Override
    public Mono<Void> shutdown() {
        return Mono.create(sink -> {
            try {
                if (!this.subject.isDisposed()) {
                    this.subject.dispose();
                }
            }
            catch (Throwable ex) {
                LOGGER.warn("Exception occured at disposing registration event subject: " + ex);
            }
            sink.success();
        });
    }
}

