/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.methods;

import io.scalecube.services.CommunicationMode;
import io.scalecube.services.api.Qualifier;
import io.scalecube.services.api.ServiceMessage;

public final class MethodInfo {
    private final String serviceName;
    private final String methodName;
    private final String qualifier;
    private final Class<?> parameterizedReturnType;
    private final CommunicationMode communicationMode;
    private final int parameterCount;
    private final Class<?> requestType;

    public MethodInfo(String serviceName, String methodName, Class<?> parameterizedReturnType, CommunicationMode communicationMode, int parameterCount, Class<?> requestType) {
        this.parameterizedReturnType = parameterizedReturnType;
        this.communicationMode = communicationMode;
        this.serviceName = serviceName;
        this.methodName = methodName;
        this.qualifier = Qualifier.asString(serviceName, methodName);
        this.parameterCount = parameterCount;
        this.requestType = requestType;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String methodName() {
        return this.methodName;
    }

    public String qualifier() {
        return this.qualifier;
    }

    public Class<?> parameterizedReturnType() {
        return this.parameterizedReturnType;
    }

    public CommunicationMode communicationMode() {
        return this.communicationMode;
    }

    public int parameterCount() {
        return this.parameterCount;
    }

    public boolean isRequestTypeServiceMessage() {
        return this.requestType.isAssignableFrom(ServiceMessage.class);
    }

    public boolean isRequestTypeVoid() {
        return this.requestType.isAssignableFrom(Void.TYPE);
    }

    public Class<?> requestType() {
        return this.requestType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MethodInfo{");
        sb.append("serviceName='").append(this.serviceName).append('\'');
        sb.append(", methodName='").append(this.methodName).append('\'');
        sb.append(", qualifier='").append(this.qualifier).append('\'');
        sb.append(", parameterizedReturnType=").append(this.parameterizedReturnType);
        sb.append(", communicationMode=").append((Object)this.communicationMode);
        sb.append(", parameterCount=").append(this.parameterCount);
        sb.append(", requestType=").append(this.requestType);
        sb.append('}');
        return sb.toString();
    }
}

