/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.exceptions;

import io.scalecube.services.api.ErrorData;
import io.scalecube.services.api.Qualifier;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.exceptions.BadRequestException;
import io.scalecube.services.exceptions.InternalServiceException;
import io.scalecube.services.exceptions.ServiceException;
import io.scalecube.services.exceptions.ServiceUnavailableException;
import io.scalecube.services.exceptions.UnauthorizedException;
import java.util.Optional;

public class ExceptionProcessor {
    private static final int DEFAULT_ERROR_CODE = 500;

    public static boolean isError(ServiceMessage message) {
        return message.qualifier().contains("io.scalecube.services.error");
    }

    public static ServiceMessage toMessage(Throwable throwable) {
        int errorCode = 500;
        int errorType = 500;
        if (throwable instanceof ServiceException) {
            errorCode = ((ServiceException)throwable).errorCode();
            if (throwable instanceof BadRequestException) {
                errorType = 400;
            } else if (throwable instanceof UnauthorizedException) {
                errorType = 401;
            } else if (throwable instanceof ServiceUnavailableException) {
                errorType = 503;
            } else if (throwable instanceof InternalServiceException) {
                errorType = 500;
            }
        }
        String errorMessage = Optional.ofNullable(throwable.getMessage()).orElseGet(throwable::toString);
        ErrorData errorData = new ErrorData(errorCode, errorMessage);
        return ServiceMessage.builder().qualifier(Qualifier.asError(errorType)).data(errorData).build();
    }

    public static ServiceException toException(String qualifier, ErrorData data) {
        int errorType = Integer.parseInt(Qualifier.getQualifierAction(qualifier));
        int errorCode = data.getErrorCode();
        String errorMessage = data.getErrorMessage();
        switch (errorType) {
            case 400: {
                return new BadRequestException(errorCode, errorMessage);
            }
            case 401: {
                return new UnauthorizedException(errorCode, errorMessage);
            }
            case 503: {
                return new ServiceUnavailableException(errorCode, errorMessage);
            }
            case 500: {
                return new InternalServiceException(errorCode, errorMessage);
            }
        }
        return new InternalServiceException(errorCode, errorMessage);
    }

    public static Throwable mapException(Throwable throwable) {
        if (ServiceException.class.isAssignableFrom(throwable.getClass())) {
            return throwable;
        }
        String errorMessage = Optional.ofNullable(throwable.getMessage()).orElseGet(throwable::toString);
        return new InternalServiceException(500, errorMessage);
    }
}

