/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.discovery;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.google.common.base.Throwables;
import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.Member;
import io.scalecube.services.ServiceEndpoint;
import io.scalecube.services.registry.api.ServiceRegistry;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDiscovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceDiscovery.class);
    private static final ObjectMapper objectMapper = ServiceDiscovery.newObjectMapper();
    public static final String SERVICE_METADATA = "service";
    private final ServiceRegistry serviceRegistry;

    public ServiceDiscovery(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void init(Cluster cluster) {
        this.loadClusterServices(cluster);
        this.listenCluster(cluster);
    }

    private void listenCluster(Cluster cluster) {
        cluster.listenMembership().subscribe(event -> {
            if (event.isAdded()) {
                this.loadMemberServices(DiscoveryType.ADDED, event.member());
            } else if (event.isRemoved()) {
                this.loadMemberServices(DiscoveryType.REMOVED, event.member());
            }
        });
    }

    private void loadClusterServices(Cluster cluster) {
        cluster.otherMembers().forEach(member -> this.loadMemberServices(DiscoveryType.DISCOVERED, (Member)member));
    }

    private void loadMemberServices(DiscoveryType type, Member member) {
        member.metadata().entrySet().stream().filter(entry -> SERVICE_METADATA.equals(entry.getValue())).forEach(entry -> {
            ServiceEndpoint serviceEndpoint = ServiceDiscovery.decodeMetadata((String)entry.getKey());
            if (serviceEndpoint == null) {
                return;
            }
            LOGGER.debug("Member: {} is {} : {}", new Object[]{member, type, serviceEndpoint});
            if ((type.equals((Object)DiscoveryType.ADDED) || type.equals((Object)DiscoveryType.DISCOVERED)) && this.serviceRegistry.registerService(serviceEndpoint)) {
                LOGGER.info("Service Reference was ADDED since new Member has joined the cluster {} : {}", (Object)member, (Object)serviceEndpoint);
            } else if (type.equals((Object)DiscoveryType.REMOVED) && this.serviceRegistry.unregisterService(serviceEndpoint.id()) != null) {
                LOGGER.info("Service Reference was REMOVED since Member have left the cluster {} : {}", (Object)member, (Object)serviceEndpoint);
            }
        });
    }

    private static ObjectMapper newObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility((VisibilityChecker<?>)objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        return objectMapper;
    }

    public static ServiceEndpoint decodeMetadata(String metadata) {
        try {
            return objectMapper.readValue(metadata, ServiceEndpoint.class);
        }
        catch (IOException e) {
            LOGGER.error("Can read metadata: " + e, e);
            return null;
        }
    }

    public static String encodeMetadata(ServiceEndpoint serviceEndpoint) {
        try {
            return objectMapper.writeValueAsString(serviceEndpoint);
        }
        catch (IOException e) {
            LOGGER.error("Can write metadata: " + e, e);
            throw Throwables.propagate(e);
        }
    }

    private static enum DiscoveryType {
        ADDED,
        REMOVED,
        DISCOVERED;

    }
}

