/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.benchmarks.jmh;

import io.scalecube.services.HeadAndTail;
import io.scalecube.services.api.ServiceMessage;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Fork(value=1)
@Threads(value=-1)
@Warmup(iterations=3)
@Measurement(iterations=3)
@State(value=Scope.Benchmark)
public class HeadAndTailBenchmarks {
    private static final ServiceMessage MESSAGE = ServiceMessage.builder().qualifier("benchmark/test").data("{\"greeting\":\"hello\"}").dataFormat("application/json").header("key1", "value1").header("key2", "value2").build();

    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Benchmark
    public void headAndTailAverageTime() {
        this.headAndTail();
    }

    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    @Benchmark
    public void headAndTailThroughput() {
        this.headAndTail();
    }

    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Benchmark
    public void flatMapAverageTime() {
        this.flatMap();
    }

    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    @Benchmark
    public void flatMapThroughput() {
        this.flatMap();
    }

    private void flatMap() {
        Flux.just(MESSAGE).flatMap(Flux::just).blockLast();
    }

    private void headAndTail() {
        Flux.from(HeadAndTail.createFrom(Mono.just(MESSAGE))).flatMap(pair -> Flux.from(pair.tail()).startWith((ServiceMessage)pair.head())).blockLast();
    }
}

