/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import com.codahale.metrics.MetricRegistry;
import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.ClusterConfig;
import io.scalecube.cluster.membership.IdGenerator;
import io.scalecube.services.Reflect;
import io.scalecube.services.ServiceCall;
import io.scalecube.services.ServiceInfo;
import io.scalecube.services.discovery.ServiceDiscovery;
import io.scalecube.services.discovery.ServiceScanner;
import io.scalecube.services.methods.ServiceMethodRegistry;
import io.scalecube.services.methods.ServiceMethodRegistryImpl;
import io.scalecube.services.metrics.Metrics;
import io.scalecube.services.registry.ServiceRegistryImpl;
import io.scalecube.services.registry.api.ServiceRegistry;
import io.scalecube.services.transport.ServiceTransport;
import io.scalecube.services.transport.client.api.ClientTransport;
import io.scalecube.services.transport.server.api.ServerTransport;
import io.scalecube.transport.Address;
import io.scalecube.transport.Addressing;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class Microservices {
    private final ServiceRegistry serviceRegistry;
    private final ClientTransport client;
    private final Metrics metrics;
    private final ServiceDiscovery discovery;
    private final ServerTransport server;
    private final ServiceMethodRegistry methodRegistry;
    private final List<ServiceInfo> services;
    private final ClusterConfig.Builder clusterConfig;
    private final String id = IdGenerator.generateId();
    private final int servicePort;
    private Address serviceAddress;
    private Cluster cluster;

    private Microservices(Builder builder) {
        this.servicePort = builder.servicePort;
        this.metrics = builder.metrics;
        this.client = builder.client;
        this.server = builder.server;
        this.clusterConfig = builder.clusterConfig;
        this.serviceRegistry = builder.serviceRegistry;
        this.services = Collections.unmodifiableList(new ArrayList(builder.services));
        this.methodRegistry = builder.methodRegistry;
        this.discovery = new ServiceDiscovery(this.serviceRegistry);
    }

    public String id() {
        return this.id;
    }

    private Mono<Microservices> start() {
        this.services.stream().map(ServiceInfo::serviceInstance).forEach(this.methodRegistry::registerService);
        InetSocketAddress address = InetSocketAddress.createUnresolved(Addressing.getLocalIpAddress().getHostAddress(), this.servicePort);
        InetSocketAddress boundAddress = this.server.bindAwait(address, this.methodRegistry);
        this.serviceAddress = Address.create(boundAddress.getHostString(), boundAddress.getPort());
        if (!this.services.isEmpty()) {
            this.serviceRegistry.registerService(ServiceScanner.scan(this.services, this.id, this.serviceAddress.host(), this.serviceAddress.port(), new HashMap<String, String>()));
        }
        this.clusterConfig.addMetadata(this.serviceRegistry.listServiceEndpoints().stream().collect(Collectors.toMap(ServiceDiscovery::encodeMetadata, service -> "service")));
        return Mono.fromFuture(Cluster.join(this.clusterConfig.build())).map(this::init);
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Collection<Object> services() {
        return this.services.stream().map(ServiceInfo::serviceInstance).collect(Collectors.toList());
    }

    private Microservices init(Cluster cluster) {
        this.cluster = cluster;
        this.discovery.init(cluster);
        return Reflect.builder(this).inject();
    }

    public static Builder builder() {
        return new Builder();
    }

    public ServiceRegistry serviceRegistry() {
        return this.serviceRegistry;
    }

    public Address serviceAddress() {
        return this.serviceAddress;
    }

    public ServiceCall.Call call() {
        return new ServiceCall.Call(this.client, this.methodRegistry, this.serviceRegistry).metrics(this.metrics);
    }

    public Mono<Void> shutdown() {
        return Mono.when(Mono.fromFuture(this.cluster.shutdown()), this.server.stop(), this.serviceRegistry.shutdown());
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public static final class Builder {
        private int servicePort = 0;
        private List<ServiceInfo> services = new ArrayList<ServiceInfo>();
        private List<Function<ServiceCall.Call, Collection<Object>>> serviceProviders = new ArrayList<Function<ServiceCall.Call, Collection<Object>>>();
        private ClusterConfig.Builder clusterConfig = ClusterConfig.builder();
        private Metrics metrics;
        private ServiceRegistry serviceRegistry = new ServiceRegistryImpl();
        private ServiceMethodRegistry methodRegistry = new ServiceMethodRegistryImpl();
        private ServerTransport server = ServiceTransport.getTransport().getServerTransport();
        private ClientTransport client = ServiceTransport.getTransport().getClientTransport();

        public Mono<Microservices> start() {
            ServiceCall.Call call = new ServiceCall.Call(this.client, this.methodRegistry, this.serviceRegistry).metrics(this.metrics);
            this.serviceProviders.stream().flatMap(provider -> ((Collection)provider.apply(call)).stream()).forEach(service -> this.services.add(service instanceof ServiceInfo ? (ServiceInfo)service : ServiceInfo.fromServiceInstance(service).build()));
            return new Microservices(this).start();
        }

        public Microservices startAwait() {
            return this.start().block();
        }

        public Builder services(Object ... services) {
            this.serviceProviders.add(call -> Arrays.stream(services).collect(Collectors.toList()));
            return this;
        }

        public Builder services(Function<ServiceCall.Call, Collection<Object>> serviceProvider) {
            this.serviceProviders.add(serviceProvider);
            return this;
        }

        public Builder serviceRegistry(ServiceRegistry serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
            return this;
        }

        public Builder methodRegistry(ServiceMethodRegistry methodRegistry) {
            this.methodRegistry = methodRegistry;
            return this;
        }

        public Builder server(ServerTransport server) {
            this.server = server;
            return this;
        }

        public Builder client(ClientTransport client) {
            this.client = client;
            return this;
        }

        public Builder discoveryPort(int port) {
            this.clusterConfig.port(port);
            return this;
        }

        public Builder servicePort(int port) {
            this.servicePort = port;
            return this;
        }

        public Builder seeds(Address ... seeds) {
            this.clusterConfig.seedMembers(seeds);
            return this;
        }

        public Builder clusterConfig(ClusterConfig.Builder clusterConfig) {
            this.clusterConfig = clusterConfig;
            return this;
        }

        public Builder metrics(MetricRegistry metrics) {
            this.metrics = new Metrics(metrics);
            return this;
        }
    }
}

