/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.gossip;

import com.google.common.base.Preconditions;
import io.scalecube.cluster.gossip.Gossip;
import java.util.HashSet;
import java.util.Set;

final class GossipState {
    private final Gossip gossip;
    private final long infectionPeriod;
    private final Set<String> infected = new HashSet<String>();

    GossipState(Gossip gossip, long infectionPeriod) {
        Preconditions.checkArgument(gossip != null);
        this.gossip = gossip;
        this.infectionPeriod = infectionPeriod;
    }

    public Gossip gossip() {
        return this.gossip;
    }

    public long infectionPeriod() {
        return this.infectionPeriod;
    }

    public void addToInfected(String memberId) {
        this.infected.add(memberId);
    }

    public boolean isInfected(String memberId) {
        return this.infected.contains(memberId);
    }

    public String toString() {
        return "GossipState{gossip=" + this.gossip + ", infectionPeriod=" + this.infectionPeriod + ", infected=" + this.infected + '}';
    }
}

