/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.benchmarks;

import io.scalecube.benchmarks.BenchmarksState;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

public class BenchmarksTask<SELF extends BenchmarksState<SELF>, T>
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BenchmarksTask.class);
    private final SELF benchmarksState;
    private final T setUpResult;
    private final BiFunction<Long, T, Publisher<?>> unitOfWork;
    private final BiFunction<SELF, T, Mono<Void>> cleanUp;
    private final long numOfIterations;
    private final Duration executionTaskDuration;
    private final Duration executionTaskInterval;
    private final Scheduler scheduler;
    private final AtomicLong iterationsCounter = new AtomicLong();
    private final AtomicReference<Status> taskStatus = new AtomicReference();
    private final CompletableFuture<Void> taskCompletionFuture = new CompletableFuture();
    private final AtomicReference<Disposable> scheduledCompletingTask = new AtomicReference();

    public BenchmarksTask(SELF benchmarksState, T setUpResult, BiFunction<Long, T, Publisher<?>> unitOfWork, BiFunction<SELF, T, Mono<Void>> cleanUp, Scheduler scheduler) {
        this.benchmarksState = benchmarksState;
        this.setUpResult = setUpResult;
        this.unitOfWork = unitOfWork;
        this.cleanUp = cleanUp;
        this.scheduler = scheduler;
        this.numOfIterations = ((BenchmarksState)benchmarksState).settings.numOfIterations();
        this.executionTaskDuration = ((BenchmarksState)benchmarksState).settings.executionTaskDuration();
        this.executionTaskInterval = ((BenchmarksState)benchmarksState).settings.executionTaskInterval();
    }

    @Override
    public void run() {
        if (this.isCompleted()) {
            return;
        }
        if (this.iterationsCounter.get() >= this.numOfIterations) {
            LOGGER.debug("Task is completed due to iterations limit: " + this.numOfIterations);
            this.startCompleting();
            return;
        }
        if (this.isScheduled()) {
            long iter2 = this.iterationsCounter.incrementAndGet();
            Flux.from(this.unitOfWork.apply(iter2, (Long)this.setUpResult)).doOnError(ex -> LOGGER.warn("Exception occured on unitOfWork at iteration: {}, cause: {}", (Object)iter2, ex)).subscribe();
            if (this.executionTaskInterval.isZero()) {
                this.scheduler.schedule(this);
            } else {
                this.scheduler.schedule(this, this.executionTaskInterval.toMillis(), TimeUnit.MILLISECONDS);
            }
            return;
        }
        if (this.setScheduled()) {
            this.scheduledCompletingTask.set(this.scheduler.schedule(() -> {
                LOGGER.debug("Task is completing due to execution duration limit: " + this.executionTaskDuration.toMillis());
                this.startCompleting();
            }, this.executionTaskDuration.toMillis(), TimeUnit.MILLISECONDS));
            LOGGER.debug("Obtained setUp result: {}, now scheduling", (Object)this.setUpResult);
            this.scheduler.schedule(this);
        }
    }

    public Mono<Void> completionMono() {
        return Mono.fromFuture(this.taskCompletionFuture);
    }

    private boolean setCompleted() {
        boolean compareAndSet = this.taskStatus.compareAndSet(Status.COMPLETING, Status.COMPLETED);
        Disposable disposable = this.scheduledCompletingTask.get();
        if (disposable != null) {
            disposable.dispose();
        }
        LOGGER.debug("Task is completed");
        this.taskCompletionFuture.obtrudeValue(null);
        return compareAndSet;
    }

    private boolean setCompletedWithError(Throwable throwable) {
        boolean compareAndSet = this.taskStatus.compareAndSet(Status.COMPLETING, Status.COMPLETED);
        Disposable disposable = this.scheduledCompletingTask.get();
        if (disposable != null) {
            disposable.dispose();
        }
        LOGGER.error("Task is completed with error: {}", throwable);
        this.taskCompletionFuture.obtrudeException(throwable);
        return compareAndSet;
    }

    private boolean setScheduled() {
        return this.taskStatus.compareAndSet(null, Status.SCHEDULED);
    }

    private boolean trySetCompleting() {
        return this.taskStatus.compareAndSet(null, Status.COMPLETING) || this.taskStatus.compareAndSet(Status.SCHEDULED, Status.COMPLETING);
    }

    private boolean isCompleted() {
        return this.taskStatus.get() == Status.COMPLETED;
    }

    private boolean isScheduled() {
        return this.taskStatus.get() == Status.SCHEDULED;
    }

    private void startCompleting() {
        if (this.trySetCompleting()) {
            try {
                Mono<Void> voidMono = this.cleanUp.apply(this.benchmarksState, this.setUpResult);
                voidMono.subscribe(aVoid -> this.setCompleted(), ex -> {
                    LOGGER.error("Exception occured on cleanUp, cause: {}", (Throwable)ex);
                    this.setCompletedWithError((Throwable)ex);
                }, this::setCompleted);
            }
            catch (Throwable ex2) {
                LOGGER.error("Exception occured on cleanUp, cause: {}", ex2);
                this.setCompletedWithError(ex2);
            }
        }
    }

    public static enum Status {
        SCHEDULED,
        COMPLETING,
        COMPLETED;

    }
}

