/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.benchmarks;

import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class BenchmarksSettings {
    private static final int N_THREADS = Runtime.getRuntime().availableProcessors();
    private static final Duration EXECUTION_TASK_DURATION = Duration.ofSeconds(60L);
    private static final Duration EXECUTION_TASK_INTERVAL = Duration.ZERO;
    private static final Duration REPORTER_INTERVAL = Duration.ofSeconds(3L);
    private static final TimeUnit DURATION_UNIT = TimeUnit.MILLISECONDS;
    private static final TimeUnit RATE_UNIT = TimeUnit.SECONDS;
    private static final long NUM_OF_ITERATIONS = Long.MAX_VALUE;
    private static final Duration RAMP_UP_DURATION = Duration.ofSeconds(10L);
    private static final Duration RAMP_UP_INTERVAL = Duration.ofSeconds(1L);
    private static final boolean CONSOLE_REPORTER_ENABLED = true;
    private final int nThreads;
    private final Duration executionTaskDuration;
    private final Duration executionTaskInterval;
    private final Duration reporterInterval;
    private final File csvReporterDirectory;
    private final String taskName;
    private final TimeUnit durationUnit;
    private final TimeUnit rateUnit;
    private final MetricRegistry registry;
    private final long numOfIterations;
    private final Duration rampUpDuration;
    private final Duration rampUpInterval;
    private final boolean consoleReporterEnabled;
    private final Map<String, String> options;

    public static Builder from(String[] args) {
        return new Builder().from(args);
    }

    private BenchmarksSettings(Builder builder) {
        this.nThreads = builder.nThreads;
        this.executionTaskDuration = builder.executionTaskDuration;
        this.executionTaskInterval = builder.executionTaskInterval;
        this.reporterInterval = builder.reporterInterval;
        this.numOfIterations = builder.numOfIterations;
        this.consoleReporterEnabled = builder.consoleReporterEnabled;
        this.rampUpDuration = builder.rampUpDuration;
        this.rampUpInterval = builder.rampUpInterval;
        this.options = builder.options;
        this.durationUnit = builder.durationUnit;
        this.rateUnit = builder.rateUnit;
        this.registry = new MetricRegistry();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        this.taskName = this.minifyClassName(stackTrace[stackTrace.length - 1].getClassName());
        String time = LocalDateTime.ofInstant(Instant.now(), ZoneOffset.UTC).format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss"));
        this.csvReporterDirectory = Paths.get("benchmarks", "results", this.find("alias", this.taskName), time).toFile();
        this.csvReporterDirectory.mkdirs();
    }

    public int nThreads() {
        return this.nThreads;
    }

    public Duration executionTaskDuration() {
        return this.executionTaskDuration;
    }

    public Duration executionTaskInterval() {
        return this.executionTaskInterval;
    }

    public Duration reporterInterval() {
        return this.reporterInterval;
    }

    public File csvReporterDirectory() {
        return this.csvReporterDirectory;
    }

    public String taskName() {
        return this.taskName;
    }

    public String find(String key, String defValue) {
        return this.options.getOrDefault(key, defValue);
    }

    public MetricRegistry registry() {
        return this.registry;
    }

    public TimeUnit durationUnit() {
        return this.durationUnit;
    }

    public TimeUnit rateUnit() {
        return this.rateUnit;
    }

    public long numOfIterations() {
        return this.numOfIterations;
    }

    public Duration rampUpDuration() {
        return this.rampUpDuration;
    }

    public Duration rampUpInterval() {
        return this.rampUpInterval;
    }

    public boolean consoleReporterEnabled() {
        return this.consoleReporterEnabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BenchmarksSettings{");
        sb.append("nThreads=").append(this.nThreads);
        sb.append(", executionTaskDuration=").append(this.executionTaskDuration);
        sb.append(", executionTaskInterval=").append(this.executionTaskInterval);
        sb.append(", numOfIterations=").append(this.numOfIterations);
        sb.append(", reporterInterval=").append(this.reporterInterval);
        sb.append(", csvReporterDirectory=").append(this.csvReporterDirectory);
        sb.append(", taskName='").append(this.taskName).append('\'');
        sb.append(", durationUnit=").append((Object)this.durationUnit);
        sb.append(", rateUnit=").append((Object)this.rateUnit);
        sb.append(", rampUpDuration=").append(this.rampUpDuration);
        sb.append(", rampUpInterval=").append(this.rampUpInterval);
        sb.append(", consoleReporterEnabled=").append(this.consoleReporterEnabled);
        sb.append(", registry=").append(this.registry);
        sb.append(", options=").append(this.options);
        sb.append('}');
        return sb.toString();
    }

    private String minifyClassName(String className) {
        return className.replaceAll("\\B\\w+(\\.[a-zA-Z])", "$1");
    }

    static /* synthetic */ int access$1200() {
        return N_THREADS;
    }

    static /* synthetic */ Duration access$1300() {
        return EXECUTION_TASK_DURATION;
    }

    static /* synthetic */ Duration access$1400() {
        return EXECUTION_TASK_INTERVAL;
    }

    static /* synthetic */ Duration access$1500() {
        return REPORTER_INTERVAL;
    }

    static /* synthetic */ TimeUnit access$1600() {
        return DURATION_UNIT;
    }

    static /* synthetic */ TimeUnit access$1700() {
        return RATE_UNIT;
    }

    static /* synthetic */ Duration access$1800() {
        return RAMP_UP_DURATION;
    }

    static /* synthetic */ Duration access$1900() {
        return RAMP_UP_INTERVAL;
    }

    public static class Builder {
        private final Map<String, String> options = new HashMap<String, String>();
        private int nThreads = BenchmarksSettings.access$1200();
        private Duration executionTaskDuration = BenchmarksSettings.access$1300();
        private Duration executionTaskInterval = BenchmarksSettings.access$1400();
        private Duration reporterInterval = BenchmarksSettings.access$1500();
        private TimeUnit durationUnit = BenchmarksSettings.access$1600();
        private TimeUnit rateUnit = BenchmarksSettings.access$1700();
        private long numOfIterations = Long.MAX_VALUE;
        private Duration rampUpDuration = BenchmarksSettings.access$1800();
        private Duration rampUpInterval = BenchmarksSettings.access$1900();
        private boolean consoleReporterEnabled = true;

        public Builder from(String[] args) {
            this.parse(args);
            return this;
        }

        private Builder() {
        }

        public Builder nThreads(int numThreads) {
            this.nThreads = numThreads;
            return this;
        }

        public Builder executionTaskDuration(Duration executionTaskDuration) {
            this.executionTaskDuration = executionTaskDuration;
            return this;
        }

        public Builder executionTaskInterval(Duration executionTaskInterval) {
            this.executionTaskInterval = executionTaskInterval;
            return this;
        }

        public Builder reporterInterval(Duration reporterInterval) {
            this.reporterInterval = reporterInterval;
            return this;
        }

        public Builder addOption(String key, String value) {
            this.options.put(key, value);
            return this;
        }

        public Builder durationUnit(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder rateUnit(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder numOfIterations(long numOfIterations) {
            this.numOfIterations = numOfIterations;
            return this;
        }

        public Builder rampUpDuration(Duration rampUpDuration) {
            this.rampUpDuration = rampUpDuration;
            return this;
        }

        public Builder rampUpInterval(Duration rampUpInterval) {
            this.rampUpInterval = rampUpInterval;
            return this;
        }

        public Builder consoleReporterEnabled(boolean consoleReporterEnabled) {
            this.consoleReporterEnabled = consoleReporterEnabled;
            return this;
        }

        public BenchmarksSettings build() {
            return new BenchmarksSettings(this);
        }

        private void parse(String[] args) {
            if (args != null) {
                block20: for (String pair : args) {
                    String[] keyValue = pair.split("=", 2);
                    String key = keyValue[0];
                    String value = keyValue[1];
                    switch (key) {
                        case "nThreads": {
                            this.nThreads(Integer.parseInt(value));
                            continue block20;
                        }
                        case "executionTaskDurationInSec": {
                            this.executionTaskDuration(Duration.ofSeconds(Long.parseLong(value)));
                            continue block20;
                        }
                        case "executionTaskIntervalInMillis": {
                            this.executionTaskInterval(Duration.ofMillis(Long.parseLong(value)));
                            continue block20;
                        }
                        case "reporterIntervalInSec": {
                            this.reporterInterval(Duration.ofSeconds(Long.parseLong(value)));
                            continue block20;
                        }
                        case "numOfIterations": {
                            this.numOfIterations(Long.parseLong(value));
                            continue block20;
                        }
                        case "rampUpDurationInSec": {
                            this.rampUpDuration(Duration.ofSeconds(Long.parseLong(value)));
                            continue block20;
                        }
                        case "rampUpIntervalInMillis": {
                            this.rampUpInterval(Duration.ofMillis(Long.parseLong(value)));
                            continue block20;
                        }
                        case "consoleReporterEnabled": {
                            this.consoleReporterEnabled(Boolean.parseBoolean(value));
                            continue block20;
                        }
                        default: {
                            this.addOption(key, value);
                        }
                    }
                }
            }
        }
    }
}

