/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.rsocket.Payload;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public final class DefaultPayload
implements Payload {
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocateDirect(0);
    private final ByteBuffer data;
    private final ByteBuffer metadata;

    private DefaultPayload(ByteBuffer data, @Nullable ByteBuffer metadata) {
        this.data = data;
        this.metadata = metadata;
    }

    @Override
    public boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ByteBuf sliceMetadata() {
        return this.metadata == null ? Unpooled.EMPTY_BUFFER : Unpooled.wrappedBuffer(this.metadata);
    }

    @Override
    public ByteBuf sliceData() {
        return Unpooled.wrappedBuffer(this.data);
    }

    @Override
    public ByteBuffer getMetadata() {
        return this.metadata == null ? EMPTY_BUFFER : this.metadata;
    }

    @Override
    public ByteBuffer getData() {
        return this.data;
    }

    @Override
    public int refCnt() {
        return 1;
    }

    @Override
    public DefaultPayload retain() {
        return this;
    }

    @Override
    public DefaultPayload retain(int increment) {
        return this;
    }

    @Override
    public DefaultPayload touch() {
        return this;
    }

    @Override
    public DefaultPayload touch(Object hint) {
        return this;
    }

    @Override
    public boolean release() {
        return false;
    }

    @Override
    public boolean release(int decrement) {
        return false;
    }

    public static Payload create(CharSequence data) {
        return DefaultPayload.create(StandardCharsets.UTF_8.encode(CharBuffer.wrap(data)), null);
    }

    public static Payload create(CharSequence data, @Nullable CharSequence metadata) {
        return DefaultPayload.create(StandardCharsets.UTF_8.encode(CharBuffer.wrap(data)), metadata == null ? null : StandardCharsets.UTF_8.encode(CharBuffer.wrap(metadata)));
    }

    public static Payload create(CharSequence data, Charset dataCharset) {
        return DefaultPayload.create(dataCharset.encode(CharBuffer.wrap(data)), null);
    }

    public static Payload create(CharSequence data, Charset dataCharset, @Nullable CharSequence metadata, Charset metadataCharset) {
        return DefaultPayload.create(dataCharset.encode(CharBuffer.wrap(data)), metadata == null ? null : metadataCharset.encode(CharBuffer.wrap(metadata)));
    }

    public static Payload create(byte[] data) {
        return DefaultPayload.create(ByteBuffer.wrap(data), null);
    }

    public static Payload create(byte[] data, @Nullable byte[] metadata) {
        return DefaultPayload.create(ByteBuffer.wrap(data), metadata == null ? null : ByteBuffer.wrap(metadata));
    }

    public static Payload create(ByteBuffer data) {
        return DefaultPayload.create(data, null);
    }

    public static Payload create(ByteBuffer data, @Nullable ByteBuffer metadata) {
        return new DefaultPayload(data, metadata);
    }

    public static Payload create(Payload payload) {
        return DefaultPayload.create(payload.getData(), payload.hasMetadata() ? payload.getMetadata() : null);
    }
}

