/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.server;

import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.NettyDuplexConnection;
import io.rsocket.transport.netty.RSocketLengthCodec;
import io.rsocket.transport.netty.server.NettyContextCloseable;
import java.net.InetSocketAddress;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.tcp.TcpServer;

public class TcpServerTransport
implements ServerTransport<NettyContextCloseable> {
    TcpServer server;

    private TcpServerTransport(TcpServer server) {
        this.server = server;
    }

    public static TcpServerTransport create(InetSocketAddress address) {
        TcpServer server = TcpServer.create(address.getHostName(), address.getPort());
        return TcpServerTransport.create(server);
    }

    public static TcpServerTransport create(String bindAddress, int port) {
        TcpServer server = TcpServer.create(bindAddress, port);
        return TcpServerTransport.create(server);
    }

    public static TcpServerTransport create(int port) {
        TcpServer server = TcpServer.create(port);
        return TcpServerTransport.create(server);
    }

    public static TcpServerTransport create(TcpServer server) {
        return new TcpServerTransport(server);
    }

    @Override
    public Mono<NettyContextCloseable> start(ServerTransport.ConnectionAcceptor acceptor) {
        return this.server.newHandler((BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>>)((BiFunction<NettyInbound, NettyOutbound, Publisher>)(in, out) -> {
            in.context().addHandler("server-length-codec", new RSocketLengthCodec());
            NettyDuplexConnection connection = new NettyDuplexConnection((NettyInbound)in, (NettyOutbound)out, in.context());
            acceptor.apply(connection).subscribe();
            return out.neverComplete();
        })).map(NettyContextCloseable::new);
    }
}

