/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.client;

import io.rsocket.DuplexConnection;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.NettyDuplexConnection;
import io.rsocket.transport.netty.RSocketLengthCodec;
import java.net.InetSocketAddress;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.tcp.TcpClient;

public class TcpClientTransport
implements ClientTransport {
    private final TcpClient client;

    private TcpClientTransport(TcpClient client) {
        this.client = client;
    }

    public static TcpClientTransport create(int port) {
        TcpClient tcpClient = TcpClient.create(port);
        return TcpClientTransport.create(tcpClient);
    }

    public static TcpClientTransport create(String bindAddress, int port) {
        TcpClient tcpClient = TcpClient.create(bindAddress, port);
        return TcpClientTransport.create(tcpClient);
    }

    public static TcpClientTransport create(InetSocketAddress address) {
        TcpClient tcpClient = TcpClient.create(address.getHostString(), address.getPort());
        return TcpClientTransport.create(tcpClient);
    }

    public static TcpClientTransport create(TcpClient client) {
        return new TcpClientTransport(client);
    }

    @Override
    public Mono<DuplexConnection> connect() {
        return Mono.create((MonoSink<T> sink) -> this.client.newHandler((BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>>)((BiFunction<NettyInbound, NettyOutbound, Publisher>)(in, out) -> {
            in.context().addHandler("client-length-codec", new RSocketLengthCodec());
            NettyDuplexConnection connection = new NettyDuplexConnection((NettyInbound)in, (NettyOutbound)out, in.context());
            sink.success(connection);
            return connection.onClose();
        })).doOnError(sink::error).subscribe());
    }
}

