/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.rsocket.DuplexConnection;
import io.rsocket.Frame;
import io.rsocket.frame.FrameHeaderFlyweight;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;

public class WebsocketDuplexConnection
implements DuplexConnection {
    private final NettyInbound in;
    private final NettyOutbound out;
    private final NettyContext context;

    public WebsocketDuplexConnection(NettyInbound in, NettyOutbound out, NettyContext context) {
        this.in = in;
        this.out = out;
        this.context = context;
    }

    @Override
    public Mono<Void> send(Publisher<Frame> frames) {
        return Flux.from(frames).concatMap(this::sendOne).then();
    }

    @Override
    public Mono<Void> sendOne(Frame frame) {
        return this.out.sendObject(new BinaryWebSocketFrame(frame.content().skipBytes(3))).then();
    }

    @Override
    public Flux<Frame> receive() {
        return this.in.receive().map(buf -> {
            CompositeByteBuf composite = this.context.channel().alloc().compositeBuffer();
            ByteBuf length = Unpooled.wrappedBuffer(new byte[3]);
            FrameHeaderFlyweight.encodeLength(length, 0, buf.readableBytes());
            composite.addComponents(true, length, buf.retain());
            return Frame.from(composite);
        });
    }

    @Override
    public void dispose() {
        this.context.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.context.isDisposed();
    }

    @Override
    public Mono<Void> onClose() {
        return this.context.onClose();
    }
}

