/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.internal;

import io.netty.util.ReferenceCountUtil;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.core.publisher.UnicastProcessor;

public final class SwitchTransform<T, R>
extends Flux<R> {
    final Publisher<? extends T> source;
    final BiFunction<T, Flux<T>, Publisher<? extends R>> transformer;

    public SwitchTransform(Publisher<? extends T> source, BiFunction<T, Flux<T>, Publisher<? extends R>> transformer) {
        this.source = Objects.requireNonNull(source, "source");
        this.transformer = Objects.requireNonNull(transformer, "transformer");
    }

    @Override
    public void subscribe(CoreSubscriber<? super R> actual) {
        this.source.subscribe(new SwitchTransformSubscriber<T, R>(actual, this.transformer));
    }

    static final class SwitchTransformSubscriber<T, R>
    implements CoreSubscriber<T> {
        static final AtomicIntegerFieldUpdater<SwitchTransformSubscriber> ONCE = AtomicIntegerFieldUpdater.newUpdater(SwitchTransformSubscriber.class, "once");
        final CoreSubscriber<? super R> actual;
        final BiFunction<T, Flux<T>, Publisher<? extends R>> transformer;
        final UnicastProcessor<T> processor = UnicastProcessor.create();
        Subscription s;
        volatile int once;

        SwitchTransformSubscriber(CoreSubscriber<? super R> actual, BiFunction<T, Flux<T>, Publisher<? extends R>> transformer) {
            this.actual = actual;
            this.transformer = transformer;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.processor.onSubscribe(s);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.once == 0 && ONCE.compareAndSet(this, 0, 1)) {
                try {
                    Publisher<R> result = Objects.requireNonNull(this.transformer.apply(t, this.processor), "The transformer returned a null value");
                    result.subscribe(this.actual);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                    ReferenceCountUtil.safeRelease(t);
                    return;
                }
            }
            this.processor.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.processor.onError(t);
        }

        @Override
        public void onComplete() {
            this.processor.onComplete();
        }
    }
}

