/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;

public class LimitableRequestPublisher<T>
extends Flux<T>
implements Subscription {
    private final Publisher<T> source;
    private final AtomicBoolean canceled;
    private long internalRequested;
    private long externalRequested;
    private volatile boolean subscribed;
    @Nullable
    private volatile Subscription internalSubscription;

    private LimitableRequestPublisher(Publisher<T> source) {
        this.source = source;
        this.canceled = new AtomicBoolean();
    }

    public static <T> LimitableRequestPublisher<T> wrap(Publisher<T> source) {
        return new LimitableRequestPublisher<T>(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(CoreSubscriber<? super T> destination) {
        LimitableRequestPublisher limitableRequestPublisher = this;
        synchronized (limitableRequestPublisher) {
            if (this.subscribed) {
                throw new IllegalStateException("only one subscriber at a time");
            }
            this.subscribed = true;
        }
        destination.onSubscribe(new InnerSubscription());
        this.source.subscribe(new InnerSubscriber(destination));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseRequestLimit(long n) {
        LimitableRequestPublisher limitableRequestPublisher = this;
        synchronized (limitableRequestPublisher) {
            this.externalRequested = Operators.addCap(n, this.externalRequested);
        }
        this.requestN();
    }

    @Override
    public void request(long n) {
        this.increaseRequestLimit(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestN() {
        long r;
        LimitableRequestPublisher limitableRequestPublisher = this;
        synchronized (limitableRequestPublisher) {
            if (this.internalSubscription == null) {
                return;
            }
            r = Math.min(this.internalRequested, this.externalRequested);
            this.externalRequested -= r;
            this.internalRequested -= r;
        }
        if (r > 0L) {
            this.internalSubscription.request(r);
        }
    }

    @Override
    public void cancel() {
        if (this.canceled.compareAndSet(false, true) && this.internalSubscription != null) {
            this.internalSubscription.cancel();
            this.internalSubscription = null;
            this.subscribed = false;
        }
    }

    private class InnerSubscription
    implements Subscription {
        private InnerSubscription() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void request(long n) {
            LimitableRequestPublisher limitableRequestPublisher = LimitableRequestPublisher.this;
            synchronized (limitableRequestPublisher) {
                LimitableRequestPublisher.this.internalRequested = Operators.addCap(n, LimitableRequestPublisher.this.internalRequested);
            }
            LimitableRequestPublisher.this.requestN();
        }

        @Override
        public void cancel() {
            LimitableRequestPublisher.this.cancel();
        }
    }

    private class InnerSubscriber
    implements Subscriber<T> {
        Subscriber<? super T> destination;

        private InnerSubscriber(Subscriber<? super T> destination) {
            this.destination = destination;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSubscribe(Subscription s) {
            LimitableRequestPublisher limitableRequestPublisher = LimitableRequestPublisher.this;
            synchronized (limitableRequestPublisher) {
                LimitableRequestPublisher.this.internalSubscription = s;
                if (LimitableRequestPublisher.this.canceled.get()) {
                    s.cancel();
                    LimitableRequestPublisher.this.subscribed = false;
                    LimitableRequestPublisher.this.internalSubscription = null;
                }
            }
            LimitableRequestPublisher.this.requestN();
        }

        @Override
        public void onNext(T t) {
            try {
                this.destination.onNext(t);
            }
            catch (Throwable e) {
                this.onError(e);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.destination.onError(t);
        }

        @Override
        public void onComplete() {
            this.destination.onComplete();
        }
    }
}

