/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.rsocket.framing.AbstractRecyclableFragmentableFrame;
import io.rsocket.framing.FrameType;
import io.rsocket.util.RecyclerFactory;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public final class RequestFireAndForgetFrame
extends AbstractRecyclableFragmentableFrame<RequestFireAndForgetFrame> {
    private static final int OFFSET_METADATA_LENGTH = 2;
    private static final Recycler<RequestFireAndForgetFrame> RECYCLER = RecyclerFactory.createRecycler(RequestFireAndForgetFrame::new);

    private RequestFireAndForgetFrame(Recycler.Handle<RequestFireAndForgetFrame> handle) {
        super(handle);
    }

    public static RequestFireAndForgetFrame createRequestFireAndForgetFrame(ByteBuf byteBuf) {
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        return (RequestFireAndForgetFrame)RECYCLER.get().setByteBuf(byteBuf.retain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestFireAndForgetFrame createRequestFireAndForgetFrame(ByteBufAllocator byteBufAllocator, boolean follows, @Nullable String metadata, @Nullable String data) {
        ByteBuf metadataByteBuf = RequestFireAndForgetFrame.getUtf8AsByteBuf(metadata);
        ByteBuf dataByteBuf = RequestFireAndForgetFrame.getUtf8AsByteBuf(data);
        try {
            RequestFireAndForgetFrame requestFireAndForgetFrame = RequestFireAndForgetFrame.createRequestFireAndForgetFrame(byteBufAllocator, follows, metadataByteBuf, dataByteBuf);
            return requestFireAndForgetFrame;
        }
        finally {
            ReferenceCountUtil.release(metadataByteBuf);
            ReferenceCountUtil.release(dataByteBuf);
        }
    }

    public static RequestFireAndForgetFrame createRequestFireAndForgetFrame(ByteBufAllocator byteBufAllocator, boolean follows, @Nullable ByteBuf metadata, @Nullable ByteBuf data) {
        ByteBuf byteBuf = RequestFireAndForgetFrame.createFrameTypeAndFlags(byteBufAllocator, FrameType.REQUEST_FNF);
        if (follows) {
            byteBuf = RequestFireAndForgetFrame.setFollowsFlag(byteBuf);
        }
        byteBuf = RequestFireAndForgetFrame.appendMetadata(byteBufAllocator, byteBuf, metadata);
        byteBuf = RequestFireAndForgetFrame.appendData(byteBuf, data);
        return (RequestFireAndForgetFrame)RECYCLER.get().setByteBuf(byteBuf);
    }

    @Override
    public RequestFireAndForgetFrame createFragment(ByteBufAllocator byteBufAllocator, @Nullable ByteBuf metadata, @Nullable ByteBuf data) {
        return RequestFireAndForgetFrame.createRequestFireAndForgetFrame(byteBufAllocator, true, metadata, data);
    }

    @Override
    public RequestFireAndForgetFrame createNonFragment(ByteBufAllocator byteBufAllocator, @Nullable ByteBuf metadata, @Nullable ByteBuf data) {
        return RequestFireAndForgetFrame.createRequestFireAndForgetFrame(byteBufAllocator, false, metadata, data);
    }

    @Override
    public ByteBuf getUnsafeData() {
        return this.getData(2);
    }

    @Override
    @Nullable
    public ByteBuf getUnsafeMetadata() {
        return this.getMetadata(2);
    }

    public String toString() {
        return "RequestFireAndForgetFrame{follows=" + this.isFollowsFlagSet() + ", metadata=" + this.mapMetadata(ByteBufUtil::hexDump) + ", data=" + this.mapData(ByteBufUtil::hexDump) + '}';
    }
}

