/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.rsocket.framing.AbstractRecyclableMetadataAndDataFrame;
import io.rsocket.framing.FrameType;
import io.rsocket.util.RecyclerFactory;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public final class ExtensionFrame
extends AbstractRecyclableMetadataAndDataFrame<ExtensionFrame> {
    private static final int FLAG_IGNORE = 512;
    private static final int OFFSET_EXTENDED_TYPE = 2;
    private static final int OFFSET_METADATA_LENGTH = 6;
    private static final Recycler<ExtensionFrame> RECYCLER = RecyclerFactory.createRecycler(ExtensionFrame::new);

    private ExtensionFrame(Recycler.Handle<ExtensionFrame> handle) {
        super(handle);
    }

    public static ExtensionFrame createExtensionFrame(ByteBuf byteBuf) {
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        return (ExtensionFrame)RECYCLER.get().setByteBuf(byteBuf.retain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExtensionFrame createExtensionFrame(ByteBufAllocator byteBufAllocator, boolean ignore, int extendedType, @Nullable String metadata, @Nullable String data) {
        ByteBuf metadataByteBuf = ExtensionFrame.getUtf8AsByteBuf(metadata);
        ByteBuf dataByteBuf = ExtensionFrame.getUtf8AsByteBuf(data);
        try {
            ExtensionFrame extensionFrame = ExtensionFrame.createExtensionFrame(byteBufAllocator, ignore, extendedType, metadataByteBuf, dataByteBuf);
            return extensionFrame;
        }
        finally {
            ReferenceCountUtil.release(metadataByteBuf);
            ReferenceCountUtil.release(dataByteBuf);
        }
    }

    public static ExtensionFrame createExtensionFrame(ByteBufAllocator byteBufAllocator, boolean ignore, int extendedType, @Nullable ByteBuf metadata, @Nullable ByteBuf data) {
        ByteBuf byteBuf = ExtensionFrame.createFrameTypeAndFlags(byteBufAllocator, FrameType.EXT);
        if (ignore) {
            byteBuf = ExtensionFrame.setFlag(byteBuf, 512);
        }
        byteBuf = byteBuf.writeInt(extendedType);
        byteBuf = ExtensionFrame.appendMetadata(byteBufAllocator, byteBuf, metadata);
        byteBuf = ExtensionFrame.appendData(byteBuf, data);
        return (ExtensionFrame)RECYCLER.get().setByteBuf(byteBuf);
    }

    public int getExtendedType() {
        return this.getByteBuf().getInt(2);
    }

    @Override
    public ByteBuf getUnsafeData() {
        return this.getData(6);
    }

    @Override
    @Nullable
    public ByteBuf getUnsafeMetadata() {
        return this.getMetadata(6);
    }

    public boolean isIgnoreFlagSet() {
        return this.isFlagSet(512);
    }

    public String toString() {
        return "ExtensionFrame{ignore=" + this.isIgnoreFlagSet() + ", extendedType=" + this.getExtendedType() + ", metadata=" + this.mapMetadata(ByteBufUtil::hexDump) + ", data=" + this.mapData(ByteBufUtil::hexDump) + '}';
    }
}

