/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.rsocket.framing.Frame;
import io.rsocket.framing.FrameType;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import reactor.util.annotation.Nullable;

abstract class AbstractRecyclableFrame<SELF extends AbstractRecyclableFrame<SELF>>
implements Frame {
    static final int FRAME_TYPE_AND_FLAGS_BYTES = 2;
    private static final int FLAGS_MASK = 1023;
    private final Recycler.Handle<SELF> handle;
    private ByteBuf byteBuf;

    AbstractRecyclableFrame(Recycler.Handle<SELF> handle) {
        this.handle = handle;
    }

    @Override
    public final void dispose() {
        if (this.byteBuf != null) {
            ReferenceCountUtil.release(this.byteBuf);
        }
        this.byteBuf = null;
        this.handle.recycle(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractRecyclableFrame)) {
            return false;
        }
        AbstractRecyclableFrame that = (AbstractRecyclableFrame)o;
        return Objects.equals(this.byteBuf, that.byteBuf);
    }

    @Override
    public FrameType getFrameType() {
        int encodedType = this.byteBuf.getUnsignedShort(0) >> 10;
        return FrameType.fromEncodedType(encodedType);
    }

    @Override
    public final ByteBuf getUnsafeFrame() {
        return this.byteBuf.asReadOnly();
    }

    public int hashCode() {
        return Objects.hash(this.byteBuf);
    }

    static ByteBuf createFrameTypeAndFlags(ByteBufAllocator byteBufAllocator, FrameType frameType) {
        Objects.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        Objects.requireNonNull(frameType, "frameType must not be null");
        return byteBufAllocator.buffer().writeShort(AbstractRecyclableFrame.getFrameTypeAndFlags(frameType));
    }

    @Nullable
    static ByteBuf getUtf8AsByteBuf(@Nullable String s) {
        return s == null ? null : Unpooled.copiedBuffer(s, StandardCharsets.UTF_8);
    }

    static ByteBuf getUtf8AsByteBufRequired(String s, String message) {
        Objects.requireNonNull(s, message);
        return Unpooled.copiedBuffer(s, StandardCharsets.UTF_8);
    }

    static ByteBuf setFlag(ByteBuf byteBuf, int flag) {
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        return byteBuf.setShort(0, byteBuf.getShort(0) | flag & 0x3FF);
    }

    final ByteBuf getByteBuf() {
        return Objects.requireNonNull(this.byteBuf, "byteBuf must not be null");
    }

    final SELF setByteBuf(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
        return (SELF)this;
    }

    final boolean isFlagSet(int flag) {
        return (this.getByteBuf().getShort(0) & flag) != 0;
    }

    private static int getFrameTypeAndFlags(FrameType frameType) {
        return frameType.getEncodedType() << 10;
    }
}

