/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.Recycler;
import io.rsocket.Payload;
import io.rsocket.frame.ErrorFrameFlyweight;
import io.rsocket.frame.FrameHeaderFlyweight;
import io.rsocket.frame.KeepaliveFrameFlyweight;
import io.rsocket.frame.LeaseFrameFlyweight;
import io.rsocket.frame.RequestFrameFlyweight;
import io.rsocket.frame.RequestNFrameFlyweight;
import io.rsocket.frame.SetupFrameFlyweight;
import io.rsocket.frame.VersionFlyweight;
import io.rsocket.framing.FrameType;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Frame
implements Payload,
ByteBufHolder {
    private static final Recycler<Frame> RECYCLER = new Recycler<Frame>(){

        @Override
        protected Frame newObject(Recycler.Handle<Frame> handle) {
            return new Frame(handle);
        }
    };
    private final Recycler.Handle<Frame> handle;
    private ByteBuf content;

    private Frame(Recycler.Handle<Frame> handle) {
        this.handle = handle;
    }

    private void recycle() {
        this.content = null;
        this.handle.recycle(this);
    }

    @Override
    public ByteBuf content() {
        if (this.content.refCnt() <= 0) {
            throw new IllegalReferenceCountException(this.content.refCnt());
        }
        return this.content;
    }

    @Override
    public Frame copy() {
        return this.replace(this.content.copy());
    }

    @Override
    public Frame duplicate() {
        return this.replace(this.content.duplicate());
    }

    @Override
    public Frame retainedDuplicate() {
        return this.replace(this.content.retainedDuplicate());
    }

    @Override
    public Frame replace(ByteBuf content) {
        return Frame.from(content);
    }

    @Override
    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public Frame retain() {
        this.content.retain();
        return this;
    }

    @Override
    public Frame retain(int increment) {
        this.content.retain(increment);
        return this;
    }

    @Override
    public Frame touch() {
        this.content.touch();
        return this;
    }

    @Override
    public Frame touch(@Nullable Object hint) {
        this.content.touch(hint);
        return this;
    }

    @Override
    public boolean release() {
        if (this.content.release()) {
            this.recycle();
            return true;
        }
        return false;
    }

    @Override
    public boolean release(int decrement) {
        if (this.content.release(decrement)) {
            this.recycle();
            return true;
        }
        return false;
    }

    @Override
    public ByteBuf sliceMetadata() {
        return this.hasMetadata() ? FrameHeaderFlyweight.sliceFrameMetadata(this.content) : Unpooled.EMPTY_BUFFER;
    }

    @Override
    public ByteBuf sliceData() {
        return FrameHeaderFlyweight.sliceFrameData(this.content);
    }

    public int getStreamId() {
        return FrameHeaderFlyweight.streamId(this.content);
    }

    public FrameType getType() {
        return FrameHeaderFlyweight.frameType(this.content);
    }

    public int flags() {
        return FrameHeaderFlyweight.flags(this.content);
    }

    public static Frame from(ByteBuf content) {
        Frame frame = RECYCLER.get();
        frame.content = content;
        return frame;
    }

    public static boolean isFlagSet(int flags, int checkedFlag) {
        return (flags & checkedFlag) == checkedFlag;
    }

    public static int setFlag(int current, int toSet) {
        return current | toSet;
    }

    @Override
    public boolean hasMetadata() {
        return Frame.isFlagSet(this.flags(), 256);
    }

    public static void ensureFrameType(FrameType frameType, Frame frame) {
        FrameType typeInFrame = frame.getType();
        if (typeInFrame != frameType) {
            throw new AssertionError((Object)("expected " + (Object)((Object)frameType) + ", but saw" + (Object)((Object)typeInFrame)));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Frame)) {
            return false;
        }
        Frame frame = (Frame)o;
        return Objects.equals(this.content, frame.content);
    }

    public int hashCode() {
        return Objects.hash(this.content);
    }

    public String toString() {
        ByteBuf data;
        FrameType type = FrameHeaderFlyweight.frameType(this.content);
        StringBuilder payload = new StringBuilder();
        ByteBuf metadata = FrameHeaderFlyweight.sliceFrameMetadata(this.content);
        if (metadata != null && 0 < metadata.readableBytes()) {
            payload.append(String.format("metadata: \"%s\" ", metadata.toString(StandardCharsets.UTF_8)));
        }
        if (0 < (data = FrameHeaderFlyweight.sliceFrameData(this.content)).readableBytes()) {
            payload.append(String.format("data: \"%s\" ", data.toString(StandardCharsets.UTF_8)));
        }
        long streamId = FrameHeaderFlyweight.streamId(this.content);
        String additionalFlags = "";
        switch (type) {
            case LEASE: {
                additionalFlags = " Permits: " + Lease.numberOfRequests(this) + " TTL: " + Lease.ttl(this);
                break;
            }
            case REQUEST_N: {
                additionalFlags = " RequestN: " + RequestN.requestN(this);
                break;
            }
            case KEEPALIVE: {
                additionalFlags = " Respond flag: " + Keepalive.hasRespondFlag(this);
                break;
            }
            case REQUEST_STREAM: 
            case REQUEST_CHANNEL: {
                additionalFlags = " Initial Request N: " + Request.initialRequestN(this);
                break;
            }
            case ERROR: {
                additionalFlags = " Error code: " + Error.errorCode(this);
                break;
            }
            case SETUP: {
                int version = Setup.version(this);
                additionalFlags = " Version: " + VersionFlyweight.toString(version) + " keep-alive interval: " + Setup.keepaliveInterval(this) + " max lifetime: " + Setup.maxLifetime(this) + " metadata mime type: " + Setup.metadataMimeType(this) + " data mime type: " + Setup.dataMimeType(this);
            }
        }
        return "Frame => Stream ID: " + streamId + " Type: " + (Object)((Object)type) + additionalFlags + " Payload: " + payload;
    }

    public static class Keepalive {
        private Keepalive() {
        }

        public static Frame from(ByteBuf data, boolean respond) {
            Frame frame = (Frame)RECYCLER.get();
            frame.content = ByteBufAllocator.DEFAULT.buffer(KeepaliveFrameFlyweight.computeFrameLength(data.readableBytes()));
            int flags = respond ? 128 : 0;
            frame.content.writerIndex(KeepaliveFrameFlyweight.encode(frame.content, flags, data));
            return frame;
        }

        public static boolean hasRespondFlag(Frame frame) {
            Frame.ensureFrameType(FrameType.KEEPALIVE, frame);
            int flags = FrameHeaderFlyweight.flags(frame.content);
            return (flags & 0x80) == 128;
        }
    }

    public static class Cancel {
        private Cancel() {
        }

        public static Frame from(int streamId) {
            Frame frame = (Frame)RECYCLER.get();
            frame.content = ByteBufAllocator.DEFAULT.buffer(FrameHeaderFlyweight.computeFrameHeaderLength(FrameType.CANCEL, null, 0));
            frame.content.writerIndex(FrameHeaderFlyweight.encode(frame.content, streamId, 0, FrameType.CANCEL, null, Unpooled.EMPTY_BUFFER));
            return frame;
        }
    }

    public static class PayloadFrame {
        private PayloadFrame() {
        }

        public static Frame from(int streamId, FrameType type) {
            return PayloadFrame.from(streamId, type, null, Unpooled.EMPTY_BUFFER, 0);
        }

        public static Frame from(int streamId, FrameType type, Payload payload) {
            return PayloadFrame.from(streamId, type, payload, payload.hasMetadata() ? 256 : 0);
        }

        public static Frame from(int streamId, FrameType type, Payload payload, int flags) {
            ByteBuf metadata = payload.hasMetadata() ? payload.sliceMetadata() : null;
            ByteBuf data = payload.sliceData();
            return PayloadFrame.from(streamId, type, metadata, data, flags);
        }

        public static Frame from(int streamId, FrameType type, @Nullable ByteBuf metadata, ByteBuf data, int flags) {
            Frame frame = (Frame)RECYCLER.get();
            frame.content = ByteBufAllocator.DEFAULT.buffer(FrameHeaderFlyweight.computeFrameHeaderLength(type, metadata != null ? Integer.valueOf(metadata.readableBytes()) : null, data.readableBytes()));
            frame.content.writerIndex(FrameHeaderFlyweight.encode(frame.content, streamId, flags, type, metadata, data));
            return frame;
        }
    }

    public static class Request {
        private Request() {
        }

        public static Frame from(int streamId, FrameType type, Payload payload, long initialRequestN) {
            int v = initialRequestN > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)initialRequestN;
            return Request.from(streamId, type, payload, v);
        }

        public static Frame from(int streamId, FrameType type, Payload payload, int initialRequestN) {
            if (initialRequestN < 1) {
                throw new IllegalStateException("initial request n must be greater than 0");
            }
            ByteBuf metadata = payload.hasMetadata() ? payload.sliceMetadata() : null;
            ByteBuf data = payload.sliceData();
            Frame frame = (Frame)RECYCLER.get();
            frame.content = ByteBufAllocator.DEFAULT.buffer(RequestFrameFlyweight.computeFrameLength(type, metadata != null ? Integer.valueOf(metadata.readableBytes()) : null, data.readableBytes()));
            if (type.hasInitialRequestN()) {
                frame.content.writerIndex(RequestFrameFlyweight.encode(frame.content, streamId, metadata != null ? 256 : 0, type, initialRequestN, metadata, data));
            } else {
                frame.content.writerIndex(RequestFrameFlyweight.encode(frame.content, streamId, metadata != null ? 256 : 0, type, metadata, data));
            }
            return frame;
        }

        public static Frame from(int streamId, FrameType type, int flags) {
            Frame frame = (Frame)RECYCLER.get();
            frame.content = ByteBufAllocator.DEFAULT.buffer(RequestFrameFlyweight.computeFrameLength(type, null, 0));
            frame.content.writerIndex(RequestFrameFlyweight.encode(frame.content, streamId, flags, type, Unpooled.EMPTY_BUFFER, Unpooled.EMPTY_BUFFER));
            return frame;
        }

        public static Frame from(int streamId, FrameType type, ByteBuf metadata, ByteBuf data, int initialRequestN, int flags) {
            Frame frame = (Frame)RECYCLER.get();
            frame.content = ByteBufAllocator.DEFAULT.buffer(RequestFrameFlyweight.computeFrameLength(type, metadata.readableBytes(), data.readableBytes()));
            frame.content.writerIndex(RequestFrameFlyweight.encode(frame.content, streamId, flags, type, initialRequestN, metadata, data));
            return frame;
        }

        public static int initialRequestN(Frame frame) {
            int result;
            FrameType type = frame.getType();
            if (!type.isRequestType()) {
                throw new AssertionError((Object)("expected request type, but saw " + type.name()));
            }
            switch (frame.getType()) {
                case REQUEST_RESPONSE: {
                    result = 1;
                    break;
                }
                case REQUEST_FNF: 
                case METADATA_PUSH: {
                    result = 0;
                    break;
                }
                default: {
                    result = RequestFrameFlyweight.initialRequestN(frame.content);
                }
            }
            return result;
        }

        public static boolean isRequestChannelComplete(Frame frame) {
            Frame.ensureFrameType(FrameType.REQUEST_CHANNEL, frame);
            int flags = FrameHeaderFlyweight.flags(frame.content);
            return (flags & 0x40) == 64;
        }
    }

    public static class RequestN {
        private RequestN() {
        }

        public static Frame from(int streamId, long requestN) {
            int v = requestN > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)requestN;
            return RequestN.from(streamId, v);
        }

        public static Frame from(int streamId, int requestN) {
            if (requestN < 1) {
                throw new IllegalStateException("request n must be greater than 0");
            }
            Frame frame = (Frame)RECYCLER.get();
            frame.content = ByteBufAllocator.DEFAULT.buffer(RequestNFrameFlyweight.computeFrameLength());
            frame.content.writerIndex(RequestNFrameFlyweight.encode(frame.content, streamId, requestN));
            return frame;
        }

        public static int requestN(Frame frame) {
            Frame.ensureFrameType(FrameType.REQUEST_N, frame);
            return RequestNFrameFlyweight.requestN(frame.content);
        }
    }

    public static class Lease {
        private Lease() {
        }

        public static Frame from(int ttl, int numberOfRequests, ByteBuf metadata) {
            Frame frame = (Frame)RECYCLER.get();
            frame.content = ByteBufAllocator.DEFAULT.buffer(LeaseFrameFlyweight.computeFrameLength(metadata.readableBytes()));
            frame.content.writerIndex(LeaseFrameFlyweight.encode(frame.content, ttl, numberOfRequests, metadata));
            return frame;
        }

        public static int ttl(Frame frame) {
            Frame.ensureFrameType(FrameType.LEASE, frame);
            return LeaseFrameFlyweight.ttl(frame.content);
        }

        public static int numberOfRequests(Frame frame) {
            Frame.ensureFrameType(FrameType.LEASE, frame);
            return LeaseFrameFlyweight.numRequests(frame.content);
        }
    }

    public static class Error {
        private static final Logger errorLogger = LoggerFactory.getLogger(Error.class);

        private Error() {
        }

        public static Frame from(int streamId, Throwable throwable, ByteBuf dataBuffer) {
            if (errorLogger.isDebugEnabled()) {
                errorLogger.debug("an error occurred, creating error frame", throwable);
            }
            int code = ErrorFrameFlyweight.errorCodeFromException(throwable);
            Frame frame = (Frame)RECYCLER.get();
            frame.content = ByteBufAllocator.DEFAULT.buffer(ErrorFrameFlyweight.computeFrameLength(dataBuffer.readableBytes()));
            frame.content.writerIndex(ErrorFrameFlyweight.encode(frame.content, streamId, code, dataBuffer));
            return frame;
        }

        public static Frame from(int streamId, Throwable throwable) {
            String data = throwable.getMessage() == null ? "" : throwable.getMessage();
            byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
            return Error.from(streamId, throwable, Unpooled.wrappedBuffer(bytes));
        }

        public static int errorCode(Frame frame) {
            Frame.ensureFrameType(FrameType.ERROR, frame);
            return ErrorFrameFlyweight.errorCode(frame.content);
        }

        public static String message(Frame frame) {
            Frame.ensureFrameType(FrameType.ERROR, frame);
            return ErrorFrameFlyweight.message(frame.content);
        }
    }

    public static class Setup {
        private Setup() {
        }

        public static Frame from(int flags, int keepaliveInterval, int maxLifetime, String metadataMimeType, String dataMimeType, Payload payload) {
            ByteBuf metadata = payload.hasMetadata() ? payload.sliceMetadata() : Unpooled.EMPTY_BUFFER;
            ByteBuf data = payload.sliceData();
            Frame frame = (Frame)RECYCLER.get();
            frame.content = ByteBufAllocator.DEFAULT.buffer(SetupFrameFlyweight.computeFrameLength(flags, metadataMimeType, dataMimeType, metadata.readableBytes(), data.readableBytes()));
            frame.content.writerIndex(SetupFrameFlyweight.encode(frame.content, flags, keepaliveInterval, maxLifetime, metadataMimeType, dataMimeType, metadata, data));
            return frame;
        }

        public static int getFlags(Frame frame) {
            Frame.ensureFrameType(FrameType.SETUP, frame);
            int flags = FrameHeaderFlyweight.flags(frame.content);
            return flags & 0x1C0;
        }

        public static int version(Frame frame) {
            Frame.ensureFrameType(FrameType.SETUP, frame);
            return SetupFrameFlyweight.version(frame.content);
        }

        public static int keepaliveInterval(Frame frame) {
            Frame.ensureFrameType(FrameType.SETUP, frame);
            return SetupFrameFlyweight.keepaliveInterval(frame.content);
        }

        public static int maxLifetime(Frame frame) {
            Frame.ensureFrameType(FrameType.SETUP, frame);
            return SetupFrameFlyweight.maxLifetime(frame.content);
        }

        public static String metadataMimeType(Frame frame) {
            Frame.ensureFrameType(FrameType.SETUP, frame);
            return SetupFrameFlyweight.metadataMimeType(frame.content);
        }

        public static String dataMimeType(Frame frame) {
            Frame.ensureFrameType(FrameType.SETUP, frame);
            return SetupFrameFlyweight.dataMimeType(frame.content);
        }
    }
}

