/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.options;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.resources.LoopResources;
import reactor.util.function.Tuple2;

public abstract class NettyOptions<BOOTSTRAP extends AbstractBootstrap<BOOTSTRAP, ?>, SO extends NettyOptions<BOOTSTRAP, SO>>
implements Supplier<BOOTSTRAP> {
    public static final int DEFAULT_PORT = System.getenv("PORT") != null ? Integer.parseInt(System.getenv("PORT")) : 12012;
    private final BOOTSTRAP bootstrapTemplate;
    private final boolean preferNative;
    private final LoopResources loopResources;
    private final SslContext sslContext;
    private final long sslHandshakeTimeoutMillis;
    private final long sslCloseNotifyFlushTimeoutMillis;
    private final long sslCloseNotifyReadTimeoutMillis;
    protected final Consumer<? super Channel> afterChannelInit;
    protected final Consumer<? super NettyContext> afterNettyContextInit;
    private final Predicate<? super Channel> onChannelInit;

    protected NettyOptions(Builder<BOOTSTRAP, SO, ?> builder) {
        this.bootstrapTemplate = builder.bootstrapTemplate;
        this.preferNative = ((Builder)builder).preferNative;
        this.loopResources = ((Builder)builder).loopResources;
        this.sslContext = ((Builder)builder).sslContext;
        this.sslHandshakeTimeoutMillis = ((Builder)builder).sslHandshakeTimeoutMillis;
        this.sslCloseNotifyFlushTimeoutMillis = ((Builder)builder).sslCloseNotifyFlushTimeoutMillis;
        this.sslCloseNotifyReadTimeoutMillis = ((Builder)builder).sslCloseNotifyReadTimeoutMillis;
        this.afterNettyContextInit = ((Builder)builder).afterNettyContextInit;
        this.onChannelInit = ((Builder)builder).onChannelInit;
        Consumer<Object> afterChannel = ((Builder)builder).afterChannelInit;
        this.afterChannelInit = afterChannel != null && ((Builder)builder).channelGroup != null ? ((Consumer<Channel>)((Builder)builder).channelGroup::add).andThen((Consumer<Channel>)afterChannel) : (afterChannel != null ? afterChannel : (((Builder)builder).channelGroup != null ? ((Builder)builder).channelGroup::add : null));
    }

    public final Consumer<? super Channel> afterChannelInit() {
        return this.afterChannelInit;
    }

    public final Consumer<? super NettyContext> afterNettyContextInit() {
        return this.afterNettyContextInit;
    }

    public boolean isSecure() {
        return this.sslContext != null;
    }

    public abstract SO duplicate();

    @Override
    public BOOTSTRAP get() {
        return (BOOTSTRAP)((AbstractBootstrap)this.bootstrapTemplate).clone();
    }

    public abstract SocketAddress getAddress();

    public final LoopResources getLoopResources() {
        return this.loopResources;
    }

    public SslHandler getSslHandler(ByteBufAllocator allocator, Tuple2<String, Integer> sniInfo) {
        SslContext sslContext;
        SslContext sslContext2 = sslContext = this.sslContext == null ? this.defaultSslContext() : this.sslContext;
        if (sslContext == null) {
            return null;
        }
        Objects.requireNonNull(allocator, "allocator");
        SslHandler sslHandler = sniInfo != null && sniInfo.getT1() != null && sniInfo.getT2() != null ? sslContext.newHandler(allocator, sniInfo.getT1(), sniInfo.getT2()) : sslContext.newHandler(allocator);
        sslHandler.setHandshakeTimeoutMillis(this.sslHandshakeTimeoutMillis);
        sslHandler.setCloseNotifyFlushTimeoutMillis(this.sslCloseNotifyFlushTimeoutMillis);
        sslHandler.setCloseNotifyReadTimeoutMillis(this.sslCloseNotifyReadTimeoutMillis);
        return sslHandler;
    }

    public final Predicate<? super Channel> onChannelInit() {
        return this.onChannelInit;
    }

    public final boolean preferNative() {
        return this.preferNative;
    }

    public final SslContext sslContext() {
        return this.sslContext;
    }

    public final long sslHandshakeTimeoutMillis() {
        return this.sslHandshakeTimeoutMillis;
    }

    public final long sslCloseNotifyFlushTimeoutMillis() {
        return this.sslCloseNotifyFlushTimeoutMillis;
    }

    public final long sslCloseNotifyReadTimeoutMillis() {
        return this.sslCloseNotifyReadTimeoutMillis;
    }

    protected SslContext defaultSslContext() {
        return null;
    }

    public String asSimpleString() {
        return this.asDetailedString();
    }

    public String asDetailedString() {
        return "bootstrapTemplate=" + this.bootstrapTemplate + ", sslHandshakeTimeoutMillis=" + this.sslHandshakeTimeoutMillis + ", sslCloseNotifyFlushTimeoutMillis=" + this.sslCloseNotifyFlushTimeoutMillis + ", sslCloseNotifyReadTimeoutMillis=" + this.sslCloseNotifyReadTimeoutMillis + ", sslContext=" + this.sslContext + ", preferNative=" + this.preferNative + ", afterChannelInit=" + this.afterChannelInit + ", onChannelInit=" + this.onChannelInit + ", loopResources=" + this.loopResources;
    }

    public String toString() {
        return "NettyOptions{" + this.asDetailedString() + "}";
    }

    public static abstract class Builder<BOOTSTRAP extends AbstractBootstrap<BOOTSTRAP, ?>, SO extends NettyOptions<BOOTSTRAP, SO>, BUILDER extends Builder<BOOTSTRAP, SO, BUILDER>>
    implements Supplier<BUILDER> {
        private static final boolean DEFAULT_NATIVE;
        protected BOOTSTRAP bootstrapTemplate;
        private boolean preferNative = DEFAULT_NATIVE;
        private LoopResources loopResources = null;
        private ChannelGroup channelGroup = null;
        private SslContext sslContext = null;
        private long sslHandshakeTimeoutMillis = 10000L;
        private long sslCloseNotifyFlushTimeoutMillis = 3000L;
        private long sslCloseNotifyReadTimeoutMillis = 0L;
        private Consumer<? super Channel> afterChannelInit = null;
        private Consumer<? super NettyContext> afterNettyContextInit = null;
        private Predicate<? super Channel> onChannelInit = null;

        protected Builder(BOOTSTRAP bootstrapTemplate) {
            this.bootstrapTemplate = bootstrapTemplate;
            this.defaultNettyOptions((AbstractBootstrap<?, ?>)this.bootstrapTemplate);
        }

        private void defaultNettyOptions(AbstractBootstrap<?, ?> bootstrap) {
            bootstrap.option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
        }

        public <T> BUILDER attr(AttributeKey<T> key, T value) {
            ((AbstractBootstrap)this.bootstrapTemplate).attr(key, value);
            return (BUILDER)((Builder)this.get());
        }

        public <T> BUILDER option(ChannelOption<T> key, T value) {
            ((AbstractBootstrap)this.bootstrapTemplate).option(key, value);
            return (BUILDER)((Builder)this.get());
        }

        public final BUILDER preferNative(boolean preferNative) {
            this.preferNative = preferNative;
            return (BUILDER)((Builder)this.get());
        }

        public final BUILDER loopResources(LoopResources channelResources) {
            this.loopResources = Objects.requireNonNull(channelResources, "loopResources");
            return (BUILDER)((Builder)this.get());
        }

        public final boolean isLoopAvailable() {
            return this.loopResources != null;
        }

        public final BUILDER eventLoopGroup(EventLoopGroup eventLoopGroup) {
            Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
            return this.loopResources(preferNative -> eventLoopGroup);
        }

        public final BUILDER channelGroup(ChannelGroup channelGroup) {
            this.channelGroup = Objects.requireNonNull(channelGroup, "channelGroup");
            return (BUILDER)((Builder)this.get());
        }

        public final BUILDER sslContext(SslContext sslContext) {
            this.sslContext = sslContext;
            return (BUILDER)((Builder)this.get());
        }

        public final BUILDER sslHandshakeTimeout(Duration sslHandshakeTimeout) {
            Objects.requireNonNull(sslHandshakeTimeout, "sslHandshakeTimeout");
            return this.sslHandshakeTimeoutMillis(sslHandshakeTimeout.toMillis());
        }

        public final BUILDER sslHandshakeTimeoutMillis(long sslHandshakeTimeoutMillis) {
            if (sslHandshakeTimeoutMillis < 0L) {
                throw new IllegalArgumentException("ssl handshake timeout must be positive, was: " + sslHandshakeTimeoutMillis);
            }
            this.sslHandshakeTimeoutMillis = sslHandshakeTimeoutMillis;
            return (BUILDER)((Builder)this.get());
        }

        public final BUILDER sslCloseNotifyFlushTimeout(Duration sslCloseNotifyFlushTimeout) {
            Objects.requireNonNull(sslCloseNotifyFlushTimeout, "sslCloseNotifyFlushTimeout");
            return this.sslCloseNotifyFlushTimeoutMillis(sslCloseNotifyFlushTimeout.toMillis());
        }

        public final BUILDER sslCloseNotifyFlushTimeoutMillis(long sslCloseNotifyFlushTimeoutMillis) {
            if (sslCloseNotifyFlushTimeoutMillis < 0L) {
                throw new IllegalArgumentException("ssl close_notify flush timeout must be positive, was: " + sslCloseNotifyFlushTimeoutMillis);
            }
            this.sslCloseNotifyFlushTimeoutMillis = sslCloseNotifyFlushTimeoutMillis;
            return (BUILDER)((Builder)this.get());
        }

        public final BUILDER sslCloseNotifyReadTimeout(Duration sslCloseNotifyReadTimeout) {
            Objects.requireNonNull(sslCloseNotifyReadTimeout, "sslCloseNotifyReadTimeout");
            return this.sslCloseNotifyFlushTimeoutMillis(sslCloseNotifyReadTimeout.toMillis());
        }

        public final BUILDER sslCloseNotifyReadTimeoutMillis(long sslCloseNotifyReadTimeoutMillis) {
            if (sslCloseNotifyReadTimeoutMillis < 0L) {
                throw new IllegalArgumentException("ssl close_notify read timeout must be positive, was: " + sslCloseNotifyReadTimeoutMillis);
            }
            this.sslCloseNotifyReadTimeoutMillis = sslCloseNotifyReadTimeoutMillis;
            return (BUILDER)((Builder)this.get());
        }

        public final BUILDER afterChannelInit(Consumer<? super Channel> afterChannelInit) {
            this.afterChannelInit = Objects.requireNonNull(afterChannelInit, "afterChannelInit");
            return (BUILDER)((Builder)this.get());
        }

        public final BUILDER onChannelInit(Predicate<? super Channel> onChannelInit) {
            this.onChannelInit = Objects.requireNonNull(onChannelInit, "onChannelInit");
            return (BUILDER)((Builder)this.get());
        }

        public final BUILDER afterNettyContextInit(Consumer<? super NettyContext> afterNettyContextInit) {
            this.afterNettyContextInit = Objects.requireNonNull(afterNettyContextInit, "afterNettyContextInit");
            return (BUILDER)((Builder)this.get());
        }

        public BUILDER from(SO options) {
            this.bootstrapTemplate = ((NettyOptions)options).get();
            this.preferNative = ((NettyOptions)options).preferNative();
            this.loopResources = ((NettyOptions)options).getLoopResources();
            this.sslContext = ((NettyOptions)options).sslContext();
            this.sslHandshakeTimeoutMillis = ((NettyOptions)options).sslHandshakeTimeoutMillis();
            this.sslCloseNotifyFlushTimeoutMillis = ((NettyOptions)options).sslCloseNotifyFlushTimeoutMillis();
            this.sslCloseNotifyReadTimeoutMillis = ((NettyOptions)options).sslCloseNotifyReadTimeoutMillis();
            this.afterChannelInit = ((NettyOptions)options).afterChannelInit();
            this.onChannelInit = ((NettyOptions)options).onChannelInit();
            this.afterNettyContextInit = ((NettyOptions)options).afterNettyContextInit();
            return (BUILDER)((Builder)this.get());
        }

        static {
            String defaultNativeEpoll = System.getProperty("reactor.ipc.netty.epoll");
            String defaultNative = System.getProperty("reactor.netty.native");
            DEFAULT_NATIVE = defaultNative != null ? Boolean.parseBoolean(defaultNative) : (defaultNativeEpoll != null ? Boolean.parseBoolean(defaultNativeEpoll) : true);
        }
    }
}

