/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import com.google.common.base.Throwables;
import io.scalecube.transport.Address;
import io.scalecube.transport.Message;
import io.scalecube.transport.NetworkEmulator;
import io.scalecube.transport.TransportConfig;
import io.scalecube.transport.TransportImpl;
import java.util.concurrent.CompletableFuture;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import rx.Observable;

public interface Transport {
    public static Transport bindAwait() {
        return Transport.bindAwait(TransportConfig.defaultConfig());
    }

    public static Transport bindAwait(boolean useNetworkEmulator) {
        return Transport.bindAwait(TransportConfig.builder().useNetworkEmulator(useNetworkEmulator).build());
    }

    public static Transport bindAwait(TransportConfig config) {
        try {
            return Transport.bind(config).get();
        }
        catch (Exception e) {
            throw Throwables.propagate(Throwables.getRootCause(e));
        }
    }

    public static CompletableFuture<Transport> bind() {
        return Transport.bind(TransportConfig.defaultConfig());
    }

    public static CompletableFuture<Transport> bind(TransportConfig config) {
        return new TransportImpl(config).bind0();
    }

    @Nonnull
    public Address address();

    public void stop();

    public void stop(@CheckForNull CompletableFuture<Void> var1);

    public boolean isStopped();

    public void send(@CheckForNull Address var1, @CheckForNull Message var2);

    public void send(@CheckForNull Address var1, @CheckForNull Message var2, @CheckForNull CompletableFuture<Void> var3);

    @Nonnull
    public Observable<Message> listen();

    @Nonnull
    public NetworkEmulator networkEmulator();
}

