/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.methods;

import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.exceptions.BadRequestException;
import io.scalecube.services.methods.MethodInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ServiceMethodInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceMethodInvoker.class);
    private final Method method;
    private final Object service;
    private final MethodInfo methodInfo;

    public ServiceMethodInvoker(Method method, Object service, MethodInfo methodInfo) {
        this.method = method;
        this.service = service;
        this.methodInfo = methodInfo;
    }

    public Mono<ServiceMessage> invokeOne(ServiceMessage message, BiFunction<ServiceMessage, Class<?>, ServiceMessage> dataDecoder) {
        return Mono.from(this.invoke(this.toRequest(message, dataDecoder))).map(this::toResponse).switchIfEmpty(Mono.just(this.toEmptyResponse()));
    }

    public Flux<ServiceMessage> invokeMany(ServiceMessage message, BiFunction<ServiceMessage, Class<?>, ServiceMessage> dataDecoder) {
        return Flux.from(this.invoke(this.toRequest(message, dataDecoder))).map(this::toResponse).switchIfEmpty(Flux.just(this.toEmptyResponse()));
    }

    public Flux<ServiceMessage> invokeBidirectional(Publisher<ServiceMessage> publisher, BiFunction<ServiceMessage, Class<?>, ServiceMessage> dataDecoder) {
        return Flux.from(this.invoke(Flux.from(publisher).map(message -> this.toRequest((ServiceMessage)message, dataDecoder)))).map(this::toResponse).switchIfEmpty(Flux.just(this.toEmptyResponse()));
    }

    private Publisher<?> invoke(Object args) {
        Publisher result = null;
        Throwable throwable = null;
        try {
            result = this.method.getParameterCount() == 0 ? (Publisher)this.method.invoke(this.service, new Object[0]) : (Publisher)this.method.invoke(this.service, args);
            if (result == null) {
                result = Mono.empty();
            }
        }
        catch (InvocationTargetException ex) {
            throwable = Optional.ofNullable(ex.getCause()).orElse(ex);
        }
        catch (Throwable ex) {
            throwable = ex;
        }
        return throwable != null ? Mono.error(throwable) : result;
    }

    private Object toRequest(ServiceMessage message, BiFunction<ServiceMessage, Class<?>, ServiceMessage> dataDecoder) {
        ServiceMessage request = dataDecoder.apply(message, this.methodInfo.requestType());
        if (!(this.methodInfo.isRequestTypeVoid() || this.methodInfo.isRequestTypeServiceMessage() || request.hasData(this.methodInfo.requestType()))) {
            Class aClass = Optional.ofNullable(request.data()).map(Object::getClass).orElseGet(null);
            LOGGER.error("Invalid service request data type: " + aClass);
            throw new BadRequestException(String.format("Expected service request data of type: %s, but received: %s", this.methodInfo.requestType(), aClass));
        }
        return this.methodInfo.isRequestTypeServiceMessage() ? request : request.data();
    }

    private ServiceMessage toResponse(Object response) {
        return response instanceof ServiceMessage ? (ServiceMessage)response : ServiceMessage.builder().qualifier(this.methodInfo.qualifier()).data(response).build();
    }

    private ServiceMessage toEmptyResponse() {
        return ServiceMessage.builder().qualifier(this.methodInfo.qualifier()).build();
    }
}

