/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.client;

import io.rsocket.DuplexConnection;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.TransportHeaderAware;
import io.rsocket.transport.netty.WebsocketDuplexConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.http.client.HttpClient;
import reactor.ipc.netty.http.client.HttpClientOptions;

public class WebsocketClientTransport
implements ClientTransport,
TransportHeaderAware {
    private final HttpClient client;
    private String path;
    private Supplier<Map<String, String>> transportHeaders = Collections::emptyMap;

    private WebsocketClientTransport(HttpClient client, String path) {
        this.client = client;
        this.path = path;
    }

    public static WebsocketClientTransport create(int port) {
        HttpClient httpClient = HttpClient.create(port);
        return WebsocketClientTransport.create(httpClient, "/");
    }

    public static WebsocketClientTransport create(String bindAddress, int port) {
        HttpClient httpClient = HttpClient.create(bindAddress, port);
        return WebsocketClientTransport.create(httpClient, "/");
    }

    public static WebsocketClientTransport create(InetSocketAddress address) {
        return WebsocketClientTransport.create(address.getHostName(), address.getPort());
    }

    public static WebsocketClientTransport create(URI uri) {
        HttpClient httpClient = WebsocketClientTransport.createClient(uri);
        return WebsocketClientTransport.create(httpClient, uri.toString());
    }

    private static HttpClient createClient(URI uri) {
        if (WebsocketClientTransport.isSecureWebsocket(uri)) {
            return HttpClient.create((? super HttpClientOptions.Builder options) -> {
                HttpClientOptions.Builder cfr_ignored_0 = (HttpClientOptions.Builder)((HttpClientOptions.Builder)options.sslSupport()).connectAddress(() -> InetSocketAddress.createUnresolved(uri.getHost(), WebsocketClientTransport.getPort(uri, 443)));
            });
        }
        return HttpClient.create(uri.getHost(), WebsocketClientTransport.getPort(uri, 80));
    }

    public static int getPort(URI uri, int defaultPort) {
        return uri.getPort() == -1 ? defaultPort : uri.getPort();
    }

    public static boolean isSecureWebsocket(URI uri) {
        return uri.getScheme().equals("wss") || uri.getScheme().equals("https");
    }

    public static boolean isPlaintextWebsocket(URI uri) {
        return uri.getScheme().equals("ws") || uri.getScheme().equals("http");
    }

    public static WebsocketClientTransport create(HttpClient client, String path) {
        return new WebsocketClientTransport(client, path);
    }

    @Override
    public Mono<DuplexConnection> connect() {
        return Mono.create((MonoSink<T> sink) -> this.client.ws(this.path, hb -> this.transportHeaders.get().forEach(hb::set)).flatMap(response -> response.receiveWebsocket((in, out) -> {
            WebsocketDuplexConnection connection = new WebsocketDuplexConnection((NettyInbound)in, (NettyOutbound)out, in.context());
            sink.success(connection);
            return connection.onClose();
        })).doOnError(sink::error).subscribe());
    }

    @Override
    public void setTransportHeaders(Supplier<Map<String, String>> transportHeaders) {
        this.transportHeaders = transportHeaders;
    }
}

