/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.internal;

import io.netty.util.ReferenceCountUtil;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;

public final class UnboundedProcessor<T>
extends FluxProcessor<T, T>
implements Fuseable.QueueSubscription<T>,
Fuseable {
    final Queue<T> queue = Queues.unboundedMultiproducer().get();
    volatile boolean done;
    Throwable error;
    volatile CoreSubscriber<? super T> actual;
    volatile boolean cancelled;
    volatile int once;
    static final AtomicIntegerFieldUpdater<UnboundedProcessor> ONCE = AtomicIntegerFieldUpdater.newUpdater(UnboundedProcessor.class, "once");
    volatile int wip;
    static final AtomicIntegerFieldUpdater<UnboundedProcessor> WIP = AtomicIntegerFieldUpdater.newUpdater(UnboundedProcessor.class, "wip");
    volatile long requested;
    static final AtomicLongFieldUpdater<UnboundedProcessor> REQUESTED = AtomicLongFieldUpdater.newUpdater(UnboundedProcessor.class, "requested");

    @Override
    public int getBufferSize() {
        return Queues.capacity(this.queue);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (Scannable.Attr.BUFFERED == key) {
            return this.queue.size();
        }
        return super.scanUnsafe(key);
    }

    void drainRegular(Subscriber<? super T> a) {
        int missed = 1;
        Queue<T> q = this.queue;
        do {
            long e;
            long r = this.requested;
            for (e = 0L; r != e; ++e) {
                boolean empty;
                boolean d = this.done;
                T t = q.poll();
                boolean bl = empty = t == null;
                if (this.checkTerminated(d, empty, a, q)) {
                    return;
                }
                if (empty) break;
                a.onNext(t);
            }
            if (r == e && this.checkTerminated(this.done, q.isEmpty(), a, q)) {
                return;
            }
            if (e == 0L || r == Long.MAX_VALUE) continue;
            REQUESTED.addAndGet(this, -e);
        } while ((missed = WIP.addAndGet(this, -missed)) != 0);
    }

    public void drain() {
        if (WIP.getAndIncrement(this) != 0) {
            return;
        }
        int missed = 1;
        do {
            CoreSubscriber<? super T> a;
            if ((a = this.actual) == null) continue;
            this.drainRegular(a);
            return;
        } while ((missed = WIP.addAndGet(this, -missed)) != 0);
    }

    boolean checkTerminated(boolean d, boolean empty, Subscriber<? super T> a, Queue<T> q) {
        if (this.cancelled) {
            while (!q.isEmpty()) {
                T t = q.poll();
                if (t == null) continue;
                ReferenceCountUtil.safeRelease(t);
            }
            this.actual = null;
            return true;
        }
        if (d && empty) {
            Throwable e = this.error;
            this.actual = null;
            if (e != null) {
                a.onError(e);
            } else {
                a.onComplete();
            }
            return true;
        }
        return false;
    }

    @Override
    public void onSubscribe(Subscription s) {
        if (this.done || this.cancelled) {
            s.cancel();
        } else {
            s.request(Long.MAX_VALUE);
        }
    }

    @Override
    public int getPrefetch() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Context currentContext() {
        CoreSubscriber<T> actual = this.actual;
        return actual != null ? actual.currentContext() : Context.empty();
    }

    @Override
    public void onNext(T t) {
        if (this.done || this.cancelled) {
            Operators.onNextDropped(t, this.currentContext());
            ReferenceCountUtil.safeRelease(t);
            return;
        }
        if (!this.queue.offer(t)) {
            Throwable ex = Operators.onOperatorError(null, Exceptions.failWithOverflow(), t, this.currentContext());
            this.onError(Operators.onOperatorError(null, ex, t, this.currentContext()));
            ReferenceCountUtil.safeRelease(t);
            return;
        }
        this.drain();
    }

    @Override
    public void onError(Throwable t) {
        if (this.done || this.cancelled) {
            Operators.onErrorDropped(t, this.currentContext());
            return;
        }
        this.error = t;
        this.done = true;
        this.drain();
    }

    @Override
    public void onComplete() {
        if (this.done || this.cancelled) {
            return;
        }
        this.done = true;
        this.drain();
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Objects.requireNonNull(actual, "subscribe");
        if (this.once == 0 && ONCE.compareAndSet(this, 0, 1)) {
            actual.onSubscribe(this);
            this.actual = actual;
            if (this.cancelled) {
                this.actual = null;
            } else {
                this.drain();
            }
        } else {
            Operators.error(actual, new IllegalStateException("UnboundedProcessor allows only a single Subscriber"));
        }
    }

    @Override
    public void request(long n) {
        if (Operators.validate(n)) {
            Operators.addCap(REQUESTED, this, n);
            this.drain();
        }
    }

    @Override
    public void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        if (WIP.getAndIncrement(this) == 0) {
            this.clear();
            this.actual = null;
        }
    }

    @Override
    @Nullable
    public T poll() {
        return this.queue.poll();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public void clear() {
        while (!this.queue.isEmpty()) {
            T t = this.queue.poll();
            if (t == null) continue;
            ReferenceCountUtil.safeRelease(t);
        }
    }

    @Override
    public int requestFusion(int requestedMode) {
        return 0;
    }

    @Override
    public boolean isDisposed() {
        return this.cancelled || this.done;
    }

    @Override
    public boolean isTerminated() {
        return this.done;
    }

    @Override
    @Nullable
    public Throwable getError() {
        return this.error;
    }

    @Override
    public long downstreamCount() {
        return this.hasDownstreams() ? 1L : 0L;
    }

    @Override
    public boolean hasDownstreams() {
        return this.actual != null;
    }
}

