/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.Recycler;
import io.rsocket.framing.AbstractRecyclableDataFrame;
import io.rsocket.framing.FrameType;
import io.rsocket.util.RecyclerFactory;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public final class KeepaliveFrame
extends AbstractRecyclableDataFrame<KeepaliveFrame> {
    private static final int FLAG_RESPOND = 128;
    private static final int OFFSET_LAST_RECEIVED_POSITION = 2;
    private static final int OFFSET_DATA = 10;
    private static final Recycler<KeepaliveFrame> RECYCLER = RecyclerFactory.createRecycler(KeepaliveFrame::new);

    private KeepaliveFrame(Recycler.Handle<KeepaliveFrame> handle) {
        super(handle);
    }

    public static KeepaliveFrame createKeepaliveFrame(ByteBuf byteBuf) {
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        return (KeepaliveFrame)RECYCLER.get().setByteBuf(byteBuf.retain());
    }

    public static KeepaliveFrame createKeepaliveFrame(ByteBufAllocator byteBufAllocator, boolean respond, long lastReceivedPosition, @Nullable ByteBuf data) {
        ByteBuf byteBuf = KeepaliveFrame.createFrameTypeAndFlags(byteBufAllocator, FrameType.KEEPALIVE).writeLong(lastReceivedPosition);
        if (respond) {
            byteBuf = KeepaliveFrame.setFlag(byteBuf, 128);
        }
        byteBuf = KeepaliveFrame.appendData(byteBuf, data);
        return (KeepaliveFrame)RECYCLER.get().setByteBuf(byteBuf);
    }

    public long getLastReceivedPosition() {
        return this.getByteBuf().getLong(2);
    }

    @Override
    public ByteBuf getUnsafeData() {
        return this.getData(10);
    }

    public boolean isRespondFlagSet() {
        return this.isFlagSet(128);
    }

    public String toString() {
        return "KeepaliveFrame{respond=" + this.isRespondFlagSet() + ", lastReceivedPosition=" + this.getLastReceivedPosition() + ", data=" + this.mapData(ByteBufUtil::hexDump) + '}';
    }
}

