/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.Recycler;
import io.rsocket.framing.AbstractRecyclableFrame;
import io.rsocket.framing.Frame;
import io.rsocket.framing.LengthUtils;
import io.rsocket.util.RecyclerFactory;
import java.util.Objects;
import java.util.function.Function;

public final class FrameLengthFrame
extends AbstractRecyclableFrame<FrameLengthFrame> {
    private static final int FRAME_LENGTH_BYTES = 3;
    private static final Recycler<FrameLengthFrame> RECYCLER = RecyclerFactory.createRecycler(FrameLengthFrame::new);

    private FrameLengthFrame(Recycler.Handle<FrameLengthFrame> handle) {
        super(handle);
    }

    public static FrameLengthFrame createFrameLengthFrame(ByteBuf byteBuf) {
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        return (FrameLengthFrame)RECYCLER.get().setByteBuf(byteBuf.retain());
    }

    public static FrameLengthFrame createFrameLengthFrame(ByteBufAllocator byteBufAllocator, Frame frame) {
        Objects.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        Objects.requireNonNull(frame, "frame must not be null");
        ByteBuf frameLengthByteBuf = frame.mapFrame(frameByteBuf -> {
            ByteBuf byteBuf = byteBufAllocator.buffer(3).writeMedium(LengthUtils.getLengthAsUnsignedMedium(frameByteBuf));
            return Unpooled.wrappedBuffer(byteBuf, frameByteBuf.retain());
        });
        return (FrameLengthFrame)RECYCLER.get().setByteBuf(frameLengthByteBuf);
    }

    public int getFrameLength() {
        return this.getByteBuf().getUnsignedMedium(0);
    }

    public ByteBuf getUnsafeFrameWithoutFrameLength() {
        ByteBuf byteBuf = this.getByteBuf();
        return byteBuf.slice(3, byteBuf.readableBytes() - 3).asReadOnly();
    }

    public <T> T mapFrameWithoutFrameLength(Function<ByteBuf, T> function) {
        Objects.requireNonNull(function, "function must not be null");
        return function.apply(this.getUnsafeFrameWithoutFrameLength());
    }

    public String toString() {
        return "FrameLengthFrame{frameLength=" + this.getFrameLength() + ", frameWithoutFrameLength=" + this.mapFrameWithoutFrameLength(ByteBufUtil::hexDump) + '}';
    }
}

