/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.rsocket.frame.FrameHeaderFlyweight;
import io.rsocket.frame.VersionFlyweight;
import io.rsocket.framing.FrameType;
import java.nio.charset.StandardCharsets;

public class SetupFrameFlyweight {
    public static final int FLAGS_RESUME_ENABLE = 128;
    public static final int FLAGS_WILL_HONOR_LEASE = 64;
    public static final int VALID_FLAGS = 448;
    public static final int CURRENT_VERSION = VersionFlyweight.encode(1, 0);
    private static final int VERSION_FIELD_OFFSET = FrameHeaderFlyweight.FRAME_HEADER_LENGTH;
    private static final int KEEPALIVE_INTERVAL_FIELD_OFFSET = VERSION_FIELD_OFFSET + 4;
    private static final int MAX_LIFETIME_FIELD_OFFSET = KEEPALIVE_INTERVAL_FIELD_OFFSET + 4;
    private static final int VARIABLE_DATA_OFFSET = MAX_LIFETIME_FIELD_OFFSET + 4;

    private SetupFrameFlyweight() {
    }

    public static int computeFrameLength(int flags, String metadataMimeType, String dataMimeType, int metadataLength, int dataLength) {
        return SetupFrameFlyweight.computeFrameLength(flags, 0, metadataMimeType, dataMimeType, metadataLength, dataLength);
    }

    private static int computeFrameLength(int flags, int resumeTokenLength, String metadataMimeType, String dataMimeType, int metadataLength, int dataLength) {
        int length = FrameHeaderFlyweight.computeFrameHeaderLength(FrameType.SETUP, metadataLength, dataLength);
        length += 12;
        if ((flags & 0x80) != 0) {
            length += 2 + resumeTokenLength;
        }
        length += 1 + metadataMimeType.getBytes(StandardCharsets.UTF_8).length;
        return length += 1 + dataMimeType.getBytes(StandardCharsets.UTF_8).length;
    }

    public static int encode(ByteBuf byteBuf, int flags, int keepaliveInterval, int maxLifetime, String metadataMimeType, String dataMimeType, ByteBuf metadata, ByteBuf data) {
        if ((flags & 0x80) != 0) {
            throw new IllegalArgumentException("RESUME_ENABLE not supported");
        }
        return SetupFrameFlyweight.encode(byteBuf, flags, keepaliveInterval, maxLifetime, Unpooled.EMPTY_BUFFER, metadataMimeType, dataMimeType, metadata, data);
    }

    static int encode(ByteBuf byteBuf, int flags, int keepaliveInterval, int maxLifetime, ByteBuf resumeToken, String metadataMimeType, String dataMimeType, ByteBuf metadata, ByteBuf data) {
        int frameLength = SetupFrameFlyweight.computeFrameLength(flags, resumeToken.readableBytes(), metadataMimeType, dataMimeType, metadata.readableBytes(), data.readableBytes());
        int length = FrameHeaderFlyweight.encodeFrameHeader(byteBuf, frameLength, flags, FrameType.SETUP, 0);
        byteBuf.setInt(VERSION_FIELD_OFFSET, CURRENT_VERSION);
        byteBuf.setInt(KEEPALIVE_INTERVAL_FIELD_OFFSET, keepaliveInterval);
        byteBuf.setInt(MAX_LIFETIME_FIELD_OFFSET, maxLifetime);
        length += 12;
        if ((flags & 0x80) != 0) {
            byteBuf.setShort(length, resumeToken.readableBytes());
            int resumeTokenLength = resumeToken.readableBytes();
            byteBuf.setBytes(length += 2, resumeToken, resumeTokenLength);
            length += resumeTokenLength;
        }
        length += SetupFrameFlyweight.putMimeType(byteBuf, length, metadataMimeType);
        length += SetupFrameFlyweight.putMimeType(byteBuf, length, dataMimeType);
        length += FrameHeaderFlyweight.encodeMetadata(byteBuf, FrameType.SETUP, length, metadata);
        length += FrameHeaderFlyweight.encodeData(byteBuf, length, data);
        return length;
    }

    public static int version(ByteBuf byteBuf) {
        return byteBuf.getInt(VERSION_FIELD_OFFSET);
    }

    public static int keepaliveInterval(ByteBuf byteBuf) {
        return byteBuf.getInt(KEEPALIVE_INTERVAL_FIELD_OFFSET);
    }

    public static int maxLifetime(ByteBuf byteBuf) {
        return byteBuf.getInt(MAX_LIFETIME_FIELD_OFFSET);
    }

    public static String metadataMimeType(ByteBuf byteBuf) {
        byte[] bytes = SetupFrameFlyweight.getMimeType(byteBuf, SetupFrameFlyweight.metadataMimetypeOffset(byteBuf));
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String dataMimeType(ByteBuf byteBuf) {
        int fieldOffset = SetupFrameFlyweight.metadataMimetypeOffset(byteBuf);
        fieldOffset += 1 + byteBuf.getByte(fieldOffset);
        byte[] bytes = SetupFrameFlyweight.getMimeType(byteBuf, fieldOffset);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static int payloadOffset(ByteBuf byteBuf) {
        int fieldOffset = SetupFrameFlyweight.metadataMimetypeOffset(byteBuf);
        byte metadataMimeTypeLength = byteBuf.getByte(fieldOffset);
        byte dataMimeTypeLength = byteBuf.getByte(fieldOffset += 1 + metadataMimeTypeLength);
        return fieldOffset += 1 + dataMimeTypeLength;
    }

    private static int metadataMimetypeOffset(ByteBuf byteBuf) {
        return VARIABLE_DATA_OFFSET + SetupFrameFlyweight.resumeTokenTotalLength(byteBuf);
    }

    private static int resumeTokenTotalLength(ByteBuf byteBuf) {
        if ((FrameHeaderFlyweight.flags(byteBuf) & 0x80) == 0) {
            return 0;
        }
        return 2 + byteBuf.getShort(VARIABLE_DATA_OFFSET);
    }

    private static int putMimeType(ByteBuf byteBuf, int fieldOffset, String mimeType) {
        byte[] bytes = mimeType.getBytes(StandardCharsets.UTF_8);
        byteBuf.setByte(fieldOffset, (byte)bytes.length);
        byteBuf.setBytes(fieldOffset + 1, bytes);
        return 1 + bytes.length;
    }

    private static byte[] getMimeType(ByteBuf byteBuf, int fieldOffset) {
        byte length = byteBuf.getByte(fieldOffset);
        byte[] bytes = new byte[length];
        byteBuf.getBytes(fieldOffset + 1, bytes);
        return bytes;
    }
}

