/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.benchmarks.routers;

import io.scalecube.benchmarks.BenchmarksSettings;
import io.scalecube.benchmarks.BenchmarksState;
import io.scalecube.services.Microservices;
import io.scalecube.services.ServiceEndpoint;
import io.scalecube.services.benchmarks.jmh.RouterBenchmarks;
import io.scalecube.services.discovery.ServiceScanner;
import io.scalecube.services.registry.ServiceRegistryImpl;
import io.scalecube.services.routing.RoundRobinServiceRouter;
import io.scalecube.services.routing.Router;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;

public class RouterBenchmarksState
extends BenchmarksState<RouterBenchmarksState> {
    private static final String IDENTICAL_REFERENCE_COUNT = "100";
    private final ServiceRegistryImpl serviceRegistry = new ServiceRegistryImpl();
    private final Router router = new RoundRobinServiceRouter();

    public RouterBenchmarksState(BenchmarksSettings settings) {
        super(settings);
        String value = settings.find("identicalReferenceCount", IDENTICAL_REFERENCE_COUNT);
        int identicalReferenceCount = Integer.parseInt(value);
        List<Microservices.ServiceInfo> services = Collections.singletonList(new Microservices.ServiceInfo((Object)new RouterBenchmarks.RouterBenchmarksServiceImpl()));
        IntStream.rangeClosed(0, identicalReferenceCount).forEach(i -> {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("k1-" + i, "v1-" + i);
            tags.put("k2-" + i, "v2-" + i);
            ServiceEndpoint serviceEndpoint = ServiceScanner.scan((List)services, (String)("localhost" + i), (String)"localhost", (int)i, tags);
            this.serviceRegistry.registerService(serviceEndpoint);
        });
    }

    public Router getRouter() {
        return this.router;
    }

    public ServiceRegistryImpl getServiceRegistry() {
        return this.serviceRegistry;
    }
}

