/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.benchmarks.jmh;

import io.scalecube.cluster.membership.IdGenerator;
import io.scalecube.services.Microservices;
import io.scalecube.services.ServiceEndpoint;
import io.scalecube.services.annotations.Service;
import io.scalecube.services.annotations.ServiceMethod;
import io.scalecube.services.api.Qualifier;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.discovery.ServiceScanner;
import io.scalecube.services.registry.ServiceRegistryImpl;
import io.scalecube.services.registry.api.ServiceRegistry;
import io.scalecube.services.routing.RoundRobinServiceRouter;
import io.scalecube.services.routing.Router;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Fork(value=1)
@Threads(value=-1)
@Warmup(iterations=2)
@Measurement(iterations=3)
public class RouterBenchmarks {
    private static final String NAMESPACE = "benchmark";
    private static final String ACTION = "method1";
    private static final ServiceMessage MESSAGE = ServiceMessage.builder().qualifier(Qualifier.asString((String)"benchmark", (String)"method1")).build();

    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Benchmark
    public void roundRobinRouterAverageTime(RoundRobinRouterState state, Blackhole bh) {
        this.route(state.router, (ServiceRegistry)state.serviceRegistry, bh);
    }

    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    @Benchmark
    public void roundRobinRouterThroughput(RoundRobinRouterState state, Blackhole bh) {
        this.route(state.router, (ServiceRegistry)state.serviceRegistry, bh);
    }

    private void route(Router router, ServiceRegistry serviceRegistry, Blackhole bh) {
        bh.consume((Object)router.route(serviceRegistry, MESSAGE));
    }

    public static class RouterBenchmarksServiceImpl
    implements RouterBenchmarksService {
        @Override
        public Mono<String> method1(String request) {
            return null;
        }

        @Override
        public Flux<String> method2(int request) {
            return null;
        }

        @Override
        public Mono<String> method3(String request) {
            return null;
        }

        @Override
        public Flux<String> method4(int request) {
            return null;
        }
    }

    @Service(value="benchmark")
    public static interface RouterBenchmarksService {
        @ServiceMethod
        public Mono<String> method1(String var1);

        @ServiceMethod
        public Flux<String> method2(int var1);

        @ServiceMethod
        public Mono<String> method3(String var1);

        @ServiceMethod
        public Flux<String> method4(int var1);
    }

    @State(value=Scope.Benchmark)
    public static class RoundRobinRouterState {
        private final ServiceRegistryImpl serviceRegistry = new ServiceRegistryImpl();
        private final Router router = new RoundRobinServiceRouter();
        @Param(value={"1", "10", "100"})
        public int count;

        @Setup
        public void setUp() {
            List<Microservices.ServiceInfo> services = Collections.singletonList(new Microservices.ServiceInfo((Object)new RouterBenchmarksServiceImpl()));
            IntStream.rangeClosed(0, this.count).forEach(i -> {
                HashMap<String, String> tags = new HashMap<String, String>();
                tags.put("k1-" + i, "v1-" + i);
                tags.put("k2-" + i, "v2-" + i);
                ServiceEndpoint serviceEndpoint = ServiceScanner.scan((List)services, (String)IdGenerator.generateId(), (String)("localhost" + i), (int)i, tags);
                this.serviceRegistry.registerService(serviceEndpoint);
            });
        }
    }
}

