/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.tcp;

import java.time.Duration;
import java.util.concurrent.TimeoutException;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.NettyContext;
import reactor.util.Logger;
import reactor.util.Loggers;

public class BlockingNettyContext {
    private static final Logger LOG = Loggers.getLogger(BlockingNettyContext.class);
    private final NettyContext context;
    private final String description;
    private Duration lifecycleTimeout;
    private Thread shutdownHook;

    public BlockingNettyContext(Mono<? extends NettyContext> contextAsync, String description) {
        this(contextAsync, description, Duration.ofSeconds(45L));
    }

    public BlockingNettyContext(Mono<? extends NettyContext> contextAsync, String description, Duration lifecycleTimeout) {
        this.description = description;
        this.lifecycleTimeout = lifecycleTimeout;
        this.context = contextAsync.timeout(lifecycleTimeout, Mono.error(new TimeoutException(description + " couldn't be started within " + lifecycleTimeout.toMillis() + "ms"))).doOnNext(ctx -> LOG.info("Started {} on {}", description, ctx.address())).block();
    }

    public void setLifecycleTimeout(Duration timeout) {
        this.lifecycleTimeout = timeout;
    }

    public NettyContext getContext() {
        return this.context;
    }

    public int getPort() {
        return this.context.address().getPort();
    }

    public String getHost() {
        return this.context.address().getHostString();
    }

    public void installShutdownHook() {
        if (this.shutdownHook != null) {
            return;
        }
        this.shutdownHook = new Thread(this::shutdownFromJVM);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public boolean removeShutdownHook() {
        if (this.shutdownHook != null && Thread.currentThread() != this.shutdownHook) {
            Thread sdh = this.shutdownHook;
            this.shutdownHook = null;
            return Runtime.getRuntime().removeShutdownHook(sdh);
        }
        return false;
    }

    protected Thread getShutdownHook() {
        return this.shutdownHook;
    }

    public void shutdown() {
        if (this.context.isDisposed()) {
            return;
        }
        this.removeShutdownHook();
        this.context.dispose();
        this.context.onClose().doOnError(e -> LOG.error("Stopped {} on {} with an error {}", this.description, this.context.address(), e)).doOnTerminate(() -> LOG.info("Stopped {} on {}", this.description, this.context.address())).timeout(this.lifecycleTimeout, Mono.error(new TimeoutException(this.description + " couldn't be stopped within " + this.lifecycleTimeout.toMillis() + "ms"))).block();
    }

    protected void shutdownFromJVM() {
        if (this.context.isDisposed()) {
            return;
        }
        String hookDesc = Thread.currentThread().toString();
        this.context.dispose();
        this.context.onClose().doOnError(e -> LOG.error("Stopped {} on {} with an error {} from JVM hook {}", this.description, this.context.address(), e, hookDesc)).doOnTerminate(() -> LOG.info("Stopped {} on {} from JVM hook {}", this.description, this.context.address(), hookDesc)).timeout(this.lifecycleTimeout, Mono.error(new TimeoutException(this.description + " couldn't be stopped within " + this.lifecycleTimeout.toMillis() + "ms"))).block();
    }
}

