/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.scalecube.transport.NetworkEmulator;
import io.scalecube.transport.NetworkEmulatorException;
import io.scalecube.transport.NetworkLinkSettings;
import java.net.InetSocketAddress;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
final class NetworkEmulatorHandler
extends ChannelOutboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkEmulatorHandler.class);
    private final NetworkEmulator networkEmulator;

    public NetworkEmulatorHandler(NetworkEmulator networkEmulator) {
        this.networkEmulator = networkEmulator;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        NetworkLinkSettings networkSettings = this.resolveNetworkSettings(ctx.channel());
        this.networkEmulator.incrementMessageSentCount();
        boolean isLost = networkSettings.evaluateLoss();
        if (isLost) {
            this.networkEmulator.incrementMessageLostCount();
            if (promise != null) {
                promise.setFailure(new NetworkEmulatorException("NETWORK_BREAK detected, not sent " + msg));
            }
            return;
        }
        int delay = (int)networkSettings.evaluateDelay();
        if (delay > 0) {
            block5: {
                try {
                    ctx.channel().eventLoop().schedule(() -> {
                        ctx.writeAndFlush(msg, promise);
                        return null;
                    }, (long)delay, TimeUnit.MILLISECONDS);
                }
                catch (RejectedExecutionException e) {
                    String warn = "Rejected " + msg + " on " + ctx.channel();
                    LOGGER.warn(warn, e);
                    if (promise == null) break block5;
                    promise.setFailure(new NetworkEmulatorException(warn));
                }
            }
            return;
        }
        super.write(ctx, msg, promise);
    }

    private NetworkLinkSettings resolveNetworkSettings(Channel channel) {
        InetSocketAddress remoteSocketAddress = (InetSocketAddress)channel.remoteAddress();
        return this.networkEmulator.getLinkSettings(remoteSocketAddress);
    }
}

