/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.registry;

import io.scalecube.services.ServiceEndpoint;
import io.scalecube.services.ServiceMethodDefinition;
import io.scalecube.services.ServiceReference;
import io.scalecube.services.ServiceRegistration;
import io.scalecube.services.registry.api.ServiceRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jctools.maps.NonBlockingHashMap;

public class ServiceRegistryImpl
implements ServiceRegistry {
    private final Map<String, ServiceEndpoint> serviceEndpoints = new NonBlockingHashMap<String, ServiceEndpoint>();
    private final Map<String, List<ServiceReference>> referencesByQualifier = new NonBlockingHashMap<String, List<ServiceReference>>();

    @Override
    public List<ServiceEndpoint> listServiceEndpoints() {
        return new ArrayList<ServiceEndpoint>(this.serviceEndpoints.values());
    }

    @Override
    public List<ServiceReference> listServiceReferences() {
        return this.serviceReferenceStream().collect(Collectors.toList());
    }

    @Override
    public List<ServiceReference> lookupService(String qualifier) {
        List<ServiceReference> result = this.referencesByQualifier.get(qualifier);
        return result != null ? Collections.unmodifiableList(result) : Collections.emptyList();
    }

    @Override
    public List<ServiceReference> lookupService(Predicate<? super ServiceReference> filter) {
        Stream<ServiceReference> stream = this.serviceReferenceStream();
        if (filter != null) {
            stream = stream.filter(filter);
        }
        return stream.collect(Collectors.toList());
    }

    @Override
    public boolean registerService(ServiceEndpoint serviceEndpoint) {
        boolean success;
        boolean bl = success = this.serviceEndpoints.putIfAbsent(serviceEndpoint.id(), serviceEndpoint) == null;
        if (success) {
            serviceEndpoint.serviceRegistrations().stream().flatMap(sr -> sr.methods().stream().map(sm -> new ServiceReference((ServiceMethodDefinition)sm, (ServiceRegistration)sr, serviceEndpoint))).forEach(reference -> this.referencesByQualifier.computeIfAbsent(reference.qualifier(), k -> new CopyOnWriteArrayList()).add(reference));
        }
        return success;
    }

    @Override
    public ServiceEndpoint unregisterService(String endpointId) {
        ServiceEndpoint serviceEndpoint = this.serviceEndpoints.remove(endpointId);
        if (serviceEndpoint != null) {
            this.referencesByQualifier.values().forEach(list -> list.removeIf(sr -> sr.endpointId().equals(endpointId)));
        }
        return serviceEndpoint;
    }

    private Stream<ServiceReference> serviceReferenceStream() {
        return this.referencesByQualifier.values().stream().flatMap(Collection::stream);
    }
}

