/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.methods;

import io.scalecube.services.Reflect;
import io.scalecube.services.methods.MethodInfo;
import io.scalecube.services.methods.ServiceMethodInvoker;
import io.scalecube.services.methods.ServiceMethodRegistry;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ServiceMethodRegistryImpl
implements ServiceMethodRegistry {
    private ConcurrentMap<String, ServiceMethodInvoker> methodInvokers = new ConcurrentHashMap<String, ServiceMethodInvoker>();

    private ServiceMethodRegistryImpl() {
    }

    @Override
    public boolean containsInvoker(String qualifier) {
        return this.methodInvokers.containsKey(qualifier);
    }

    @Override
    public ServiceMethodInvoker getInvoker(String qualifier) {
        return (ServiceMethodInvoker)this.methodInvokers.get(qualifier);
    }

    public static Builder builder() {
        return new Builder();
    }

    private ServiceMethodRegistryImpl(List<Object> serviceObjects) {
        serviceObjects.forEach(service -> Reflect.serviceInterfaces(service).forEach(serviceInterface -> Reflect.serviceMethods(serviceInterface).forEach((key, method) -> {
            Reflect.validateMethodOrThrow(method);
            MethodInfo methodInfo = new MethodInfo(Reflect.serviceName(serviceInterface), Reflect.methodName(method), Reflect.parameterizedReturnType(method), Reflect.communicationMode(method), method.getParameterCount(), Reflect.requestType(method));
            this.methodInvokers.put(methodInfo.qualifier(), new ServiceMethodInvoker((Method)method, service, methodInfo));
        })));
    }

    public static class Builder {
        private List<Object> services;

        private Builder() {
        }

        public Builder services(List<Object> services) {
            this.services = services;
            return this;
        }

        public ServiceMethodRegistryImpl build() {
            return new ServiceMethodRegistryImpl(this.services);
        }
    }
}

