/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.discovery;

import io.scalecube.services.CommunicationMode;
import io.scalecube.services.Microservices;
import io.scalecube.services.Reflect;
import io.scalecube.services.ServiceEndpoint;
import io.scalecube.services.ServiceMethodDefinition;
import io.scalecube.services.ServiceRegistration;
import io.scalecube.services.annotations.ContentType;
import io.scalecube.services.annotations.Service;
import io.scalecube.services.annotations.ServiceMethod;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ServiceScanner {
    public static ServiceEndpoint scan(List<Microservices.ServiceInfo> serviceInstances, String endpointId, String host, int port, Map<String, String> endpointTags) {
        List<ServiceRegistration> serviceRegistrations = serviceInstances.stream().flatMap(inst -> Arrays.stream(inst.service().getClass().getInterfaces()).map(serviceInterface -> new InterfaceInfo((Class)serviceInterface, inst.tags()))).filter(iAndTags -> ((InterfaceInfo)iAndTags).serviceInterface.isAnnotationPresent(Service.class)).map(iAndTags -> {
            Class serviceInterface = ((InterfaceInfo)iAndTags).serviceInterface;
            Map serviceTags = ((InterfaceInfo)iAndTags).tags;
            String namespace = Reflect.serviceName(serviceInterface);
            ContentType ctAnnotation = serviceInterface.getAnnotation(ContentType.class);
            String serviceContentType = ctAnnotation != null ? ctAnnotation.value() : "application/json";
            List<ServiceMethodDefinition> actions = Arrays.stream(serviceInterface.getMethods()).filter(m -> m.isAnnotationPresent(ServiceMethod.class)).map(m -> {
                String action = Reflect.methodName(m);
                String contentType = "application/json";
                CommunicationMode communicationMode = Reflect.communicationMode(m);
                return new ServiceMethodDefinition(action, contentType, communicationMode);
            }).collect(Collectors.toList());
            return new ServiceRegistration(namespace, serviceContentType, serviceTags, actions);
        }).collect(Collectors.toList());
        return new ServiceEndpoint(endpointId, host, port, endpointTags, serviceRegistrations);
    }

    private static class InterfaceInfo {
        private final Class<?> serviceInterface;
        private final Map<String, String> tags;

        private InterfaceInfo(Class<?> serviceInterface, Map<String, String> tags) {
            this.serviceInterface = serviceInterface;
            this.tags = tags;
        }
    }
}

