/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.benchmarks.services;

import io.scalecube.benchmarks.BenchmarksSettings;
import io.scalecube.benchmarks.BenchmarksState;
import io.scalecube.services.Microservices;
import io.scalecube.services.ServiceCall;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicesBenchmarksState
extends BenchmarksState<ServicesBenchmarksState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServicesBenchmarksState.class);
    private static final Duration SHUTDOWN_TIMEOUT = Duration.ofSeconds(6L);
    private final Object[] services;
    private Microservices seed;
    private Microservices node;

    public ServicesBenchmarksState(BenchmarksSettings settings, Object ... services) {
        super(settings);
        this.services = services;
    }

    @Override
    public void beforeAll() {
        this.seed = Microservices.builder().metrics(this.settings.registry()).startAwait();
        this.node = Microservices.builder().metrics(this.settings.registry()).seeds(this.seed.cluster().address()).services(this.services).startAwait();
        LOGGER.info("Seed address: " + this.seed.cluster().address() + ", services address: " + this.node.serviceAddress() + ", seed serviceRegistry: " + this.seed.serviceRegistry().listServiceReferences());
    }

    @Override
    public void afterAll() {
        if (this.node != null) {
            try {
                this.node.shutdown().block(SHUTDOWN_TIMEOUT);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.seed != null) {
            try {
                this.seed.shutdown().block(SHUTDOWN_TIMEOUT);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public Microservices seed() {
        return this.seed;
    }

    public <T> T service(Class<T> c) {
        return this.seed.call().create().api(c);
    }

    public ServiceCall serviceCall() {
        return this.seed.call().create();
    }
}

