/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import io.scalecube.services.CommunicationMode;
import io.scalecube.services.ServiceEndpoint;
import io.scalecube.services.ServiceMethodDefinition;
import io.scalecube.services.ServiceRegistration;
import io.scalecube.services.api.Qualifier;
import java.util.HashMap;
import java.util.Map;

public class ServiceReference {
    private String qualifier;
    private String endpointId;
    private String host;
    private int port;
    private String namespace;
    private String contentType;
    private Map<String, String> tags;
    private String action;
    private CommunicationMode mode;

    public ServiceReference() {
    }

    public ServiceReference(ServiceMethodDefinition serviceMethodDefinition, ServiceRegistration serviceRegistration, ServiceEndpoint serviceEndpoint) {
        this.endpointId = serviceEndpoint.id();
        this.host = serviceEndpoint.host();
        this.port = serviceEndpoint.port();
        this.namespace = serviceRegistration.namespace();
        this.contentType = this.mergeContentType(serviceMethodDefinition, serviceRegistration);
        this.tags = this.mergeTags(serviceMethodDefinition, serviceRegistration, serviceEndpoint);
        this.action = serviceMethodDefinition.getAction();
        this.mode = serviceMethodDefinition.getCommunicationMode();
        this.qualifier = Qualifier.asString(this.namespace, this.action);
    }

    public CommunicationMode mode() {
        return this.mode;
    }

    public String qualifier() {
        return this.qualifier;
    }

    public String endpointId() {
        return this.endpointId;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String namespace() {
        return this.namespace;
    }

    public String contentType() {
        return this.contentType;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String action() {
        return this.action;
    }

    private Map<String, String> mergeTags(ServiceMethodDefinition serviceMethodDefinition, ServiceRegistration serviceRegistration, ServiceEndpoint serviceEndpoint) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.putAll(serviceEndpoint.tags());
        tags.putAll(serviceRegistration.tags());
        tags.putAll(serviceMethodDefinition.getTags());
        return tags;
    }

    private String mergeContentType(ServiceMethodDefinition serviceMethodDefinition, ServiceRegistration serviceRegistration) {
        if (serviceMethodDefinition.getContentType() != null && !serviceMethodDefinition.getContentType().isEmpty()) {
            return serviceMethodDefinition.getContentType();
        }
        if (serviceRegistration.contentType() != null && !serviceRegistration.contentType().isEmpty()) {
            return serviceRegistration.contentType();
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return "ServiceReference{qualifier='" + this.qualifier + '\'' + ", endpointId='" + this.endpointId + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", namespace='" + this.namespace + '\'' + ", contentType='" + this.contentType + '\'' + ", tags=" + this.tags + ", action='" + this.action + '\'' + ", mode=" + (Object)((Object)this.mode) + '}';
    }
}

