/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import com.codahale.metrics.MetricRegistry;
import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.ClusterConfig;
import io.scalecube.cluster.membership.IdGenerator;
import io.scalecube.services.Reflect;
import io.scalecube.services.ServiceCall;
import io.scalecube.services.ServiceEndpoint;
import io.scalecube.services.discovery.ServiceDiscovery;
import io.scalecube.services.discovery.ServiceScanner;
import io.scalecube.services.methods.ServiceMethodRegistry;
import io.scalecube.services.methods.ServiceMethodRegistryImpl;
import io.scalecube.services.metrics.Metrics;
import io.scalecube.services.registry.ServiceRegistryImpl;
import io.scalecube.services.registry.api.ServiceRegistry;
import io.scalecube.services.transport.ServiceTransport;
import io.scalecube.services.transport.client.api.ClientTransport;
import io.scalecube.services.transport.server.api.ServerTransport;
import io.scalecube.transport.Address;
import io.scalecube.transport.Addressing;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class Microservices {
    private final ServiceRegistry serviceRegistry;
    private final ClientTransport client;
    private final Metrics metrics;
    private final Address serviceAddress;
    private final ServiceDiscovery discovery;
    private final ServerTransport server;
    private final ServiceMethodRegistry methodRegistry;
    private final List<Object> services;
    private final ClusterConfig.Builder clusterConfig;
    private final String id = IdGenerator.generateId();
    private Cluster cluster;

    private Microservices(Builder builder) {
        this.metrics = builder.metrics;
        this.client = builder.client;
        this.server = builder.server;
        this.services = builder.services.stream().map(mapper -> ((ServiceInfo)mapper).serviceInstance).collect(Collectors.toList());
        this.methodRegistry = ServiceMethodRegistryImpl.builder().services(builder.services.stream().map(ServiceInfo::service).collect(Collectors.toList())).build();
        InetSocketAddress socketAddress = new InetSocketAddress(Addressing.getLocalIpAddress(), builder.servicePort);
        InetSocketAddress address = this.server.bindAwait(socketAddress, this.methodRegistry);
        this.serviceAddress = Address.create(address.getHostString(), address.getPort());
        this.serviceRegistry = new ServiceRegistryImpl();
        if (this.services.size() > 0) {
            this.serviceRegistry.registerService(ServiceScanner.scan(builder.services, this.id, this.serviceAddress.host(), this.serviceAddress.port(), new HashMap<String, String>()));
        }
        this.discovery = new ServiceDiscovery(this.serviceRegistry);
        this.clusterConfig = builder.clusterConfig;
    }

    public String id() {
        return this.id;
    }

    private Mono<Microservices> start() {
        this.clusterConfig.addMetadata(this.serviceRegistry.listServiceEndpoints().stream().collect(Collectors.toMap(ServiceDiscovery::encodeMetadata, service -> "service")));
        return Mono.fromFuture(Cluster.join(this.clusterConfig.build())).map(this::init);
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Collection<Object> services() {
        return this.services;
    }

    public Collection<ServiceEndpoint> serviceEndpoints() {
        return this.serviceRegistry.listServiceEndpoints();
    }

    private Microservices init(Cluster cluster) {
        this.cluster = cluster;
        this.discovery.init(cluster);
        return Reflect.builder(this).inject();
    }

    public static Builder builder() {
        return new Builder();
    }

    public ServiceRegistry serviceRegistry() {
        return this.serviceRegistry;
    }

    public Address serviceAddress() {
        return this.serviceAddress;
    }

    public ServiceCall.Call call() {
        return new ServiceCall.Call(this.client, this.methodRegistry, this.serviceRegistry).metrics(this.metrics);
    }

    public Mono<Void> shutdown() {
        return Mono.when(Mono.fromFuture(this.cluster.shutdown()), this.server.stop());
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public static class ServiceInfo {
        private final Object serviceInstance;
        private final Map<String, String> tags;

        public ServiceInfo(Object serviceInstance) {
            this(serviceInstance, Collections.emptyMap());
        }

        public ServiceInfo(Object serviceInstance, Map<String, String> tags) {
            this.serviceInstance = serviceInstance;
            this.tags = tags;
        }

        public Object service() {
            return this.serviceInstance;
        }

        public Map<String, String> tags() {
            return this.tags;
        }
    }

    public static class ServiceBuilder {
        private final Object serviceInstance;
        private final Map<String, String> tags = new HashMap<String, String>();
        private final Builder that;

        ServiceBuilder(Object serviceInstance, Builder that) {
            this.serviceInstance = serviceInstance;
            this.that = that;
        }

        public ServiceBuilder tag(String key, String value) {
            this.tags.put(key, value);
            return this;
        }

        public Builder register() {
            this.that.services.add(new ServiceInfo(this.serviceInstance, this.tags));
            return this.that;
        }
    }

    public static final class Builder {
        public int servicePort = 0;
        private List<ServiceInfo> services = new ArrayList<ServiceInfo>();
        private ClusterConfig.Builder clusterConfig = ClusterConfig.builder();
        private Metrics metrics;
        private ServerTransport server = ServiceTransport.getTransport().getServerTransport();
        private ClientTransport client = ServiceTransport.getTransport().getClientTransport();

        public Mono<Microservices> start() {
            Microservices instance = new Microservices(this);
            return instance.start();
        }

        public Microservices startAwait() {
            return (Microservices)new Microservices(this).start().block();
        }

        public Builder server(ServerTransport server) {
            Objects.requireNonNull(server);
            this.server = server;
            return this;
        }

        public Builder client(ClientTransport client) {
            Objects.requireNonNull(client);
            this.client = client;
            return this;
        }

        public Builder discoveryPort(int port) {
            this.clusterConfig.port(port);
            return this;
        }

        public Builder servicePort(int port) {
            this.servicePort = port;
            return this;
        }

        public Builder seeds(Address ... seeds) {
            Objects.requireNonNull(seeds);
            this.clusterConfig.seedMembers(seeds);
            return this;
        }

        public Builder clusterConfig(ClusterConfig.Builder clusterConfig) {
            Objects.requireNonNull(clusterConfig);
            this.clusterConfig = clusterConfig;
            return this;
        }

        public Builder metrics(MetricRegistry metrics) {
            Objects.requireNonNull(metrics);
            this.metrics = new Metrics(metrics);
            return this;
        }

        public Builder services(Object ... services) {
            Objects.requireNonNull(services);
            this.services = Arrays.stream(services).map(ServiceInfo::new).collect(Collectors.toList());
            return this;
        }

        public ServiceBuilder service(Object serviceInstance) {
            Objects.requireNonNull(serviceInstance);
            return new ServiceBuilder(serviceInstance, this);
        }
    }
}

