/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.membership;

import com.google.common.base.Preconditions;
import io.scalecube.cluster.Member;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MembershipEvent {
    private final Type type;
    private final Member newMember;
    private final Member oldMember;

    private MembershipEvent(Type type, Member oldMember, Member newMember) {
        Preconditions.checkArgument(type != null);
        this.type = type;
        this.oldMember = oldMember;
        this.newMember = newMember;
    }

    static MembershipEvent createRemoved(Member member) {
        return new MembershipEvent(Type.REMOVED, member, null);
    }

    static MembershipEvent createAdded(Member member) {
        return new MembershipEvent(Type.ADDED, null, member);
    }

    static MembershipEvent createUpdated(Member oldMember, Member newMember) {
        return new MembershipEvent(Type.UPDATED, oldMember, newMember);
    }

    public Type type() {
        return this.type;
    }

    public boolean isAdded() {
        return this.type == Type.ADDED;
    }

    public boolean isRemoved() {
        return this.type == Type.REMOVED;
    }

    public boolean isUpdated() {
        return this.type == Type.UPDATED;
    }

    public Member member() {
        return this.type == Type.REMOVED ? this.oldMember : this.newMember;
    }

    public Member oldMember() {
        return this.oldMember;
    }

    public Member newMember() {
        return this.newMember;
    }

    public String toString() {
        return "MembershipEvent{type=" + (Object)((Object)this.type) + ", newMember=" + this.newMember + ", oldMember=" + this.oldMember + '}';
    }

    public static enum Type {
        ADDED,
        REMOVED,
        UPDATED;

    }
}

