/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.benchmarks;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import io.scalecube.benchmarks.BenchmarksSettings;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.LongStream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class BenchmarksState<SELF extends BenchmarksState<SELF>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BenchmarksState.class);
    protected final BenchmarksSettings settings;
    private ConsoleReporter consoleReporter;
    private Scheduler scheduler;
    private CsvReporter csvReporter;
    private final AtomicBoolean started = new AtomicBoolean();

    public BenchmarksState(BenchmarksSettings settings) {
        this.settings = settings;
    }

    protected void beforeAll() throws Exception {
    }

    protected void afterAll() throws Exception {
    }

    public final void start() {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("BenchmarksState is already started");
        }
        LOGGER.info("Benchmarks settings: " + this.settings);
        this.consoleReporter = ConsoleReporter.forRegistry(this.settings.registry()).outputTo(System.out).convertDurationsTo(this.settings.durationUnit()).convertRatesTo(this.settings.rateUnit()).build();
        this.csvReporter = CsvReporter.forRegistry(this.settings.registry()).convertDurationsTo(this.settings.durationUnit()).convertRatesTo(this.settings.rateUnit()).build(this.settings.csvReporterDirectory());
        this.scheduler = Schedulers.fromExecutor(Executors.newFixedThreadPool(this.settings.nThreads()));
        try {
            this.beforeAll();
        }
        catch (Exception ex) {
            throw new IllegalStateException("BenchmarksState beforeAll() failed: " + ex, ex);
        }
        this.consoleReporter.start(this.settings.reporterPeriod().toMillis(), TimeUnit.MILLISECONDS);
        this.csvReporter.start(1L, TimeUnit.DAYS);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (this.started.get()) {
                this.csvReporter.report();
                this.consoleReporter.report();
            }
        }));
    }

    public final void shutdown() {
        if (!this.started.compareAndSet(true, false)) {
            throw new IllegalStateException("BenchmarksState is not started");
        }
        if (this.consoleReporter != null) {
            this.consoleReporter.report();
            this.consoleReporter.stop();
        }
        if (this.csvReporter != null) {
            this.csvReporter.report();
            this.csvReporter.stop();
        }
        if (this.scheduler != null) {
            this.scheduler.dispose();
        }
        try {
            this.afterAll();
        }
        catch (Exception ex) {
            throw new IllegalStateException("BenchmarksState afterAll() failed: " + ex, ex);
        }
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Timer timer(String name) {
        return this.settings.registry().timer(this.settings.taskName() + "-" + name);
    }

    public Meter meter(String name) {
        return this.settings.registry().meter(this.settings.taskName() + "-" + name);
    }

    public Histogram histogram(String name) {
        return this.settings.registry().histogram(this.settings.taskName() + "-" + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runForSync(Function<SELF, Function<Long, Object>> func) {
        BenchmarksState self = this;
        try {
            self.start();
            Function<Long, Object> unitOfWork = func.apply(self);
            Flux.merge(new Publisher[]{Flux.fromStream(LongStream.range(0L, this.settings.numOfIterations()).boxed()).publishOn(this.scheduler()).map(unitOfWork)}).take(this.settings.executionTaskTime()).blockLast();
        }
        finally {
            self.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runForAsync(Function<SELF, Function<Long, Publisher<?>>> func) {
        BenchmarksState self = this;
        try {
            self.start();
            Function<Long, Publisher<?>> unitOfWork = func.apply(self);
            Flux.merge(Flux.fromStream(LongStream.range(0L, this.settings.numOfIterations()).boxed()).publishOn(this.scheduler()).map(unitOfWork)).take(this.settings.executionTaskTime()).blockLast();
        }
        finally {
            self.shutdown();
        }
    }
}

