/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.benchmarks;

import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class BenchmarksSettings {
    private static final int N_THREADS = Runtime.getRuntime().availableProcessors();
    private static final Duration EXECUTION_TASK_TIME = Duration.ofSeconds(60L);
    private static final Duration REPORTER_PERIOD = Duration.ofSeconds(10L);
    private static final TimeUnit DURATION_UNIT = TimeUnit.MILLISECONDS;
    private static final TimeUnit RATE_UNIT = TimeUnit.SECONDS;
    private static final long NUM_OF_ITERATIONS = Long.MAX_VALUE;
    private final int nThreads;
    private final Duration executionTaskTime;
    private final Duration reporterPeriod;
    private final File csvReporterDirectory;
    private final String taskName;
    private final TimeUnit durationUnit;
    private final TimeUnit rateUnit;
    private final MetricRegistry registry;
    private final long numOfIterations;
    private final Map<String, String> options;

    public static Builder from(String[] args) {
        return new Builder().from(args);
    }

    private BenchmarksSettings(Builder builder) {
        this.nThreads = builder.nThreads;
        this.executionTaskTime = builder.executionTaskTime;
        this.reporterPeriod = builder.reporterPeriod;
        this.numOfIterations = builder.numOfIterations;
        this.options = builder.options;
        this.registry = new MetricRegistry();
        this.durationUnit = builder.durationUnit;
        this.rateUnit = builder.rateUnit;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        this.taskName = stackTrace[stackTrace.length - 1].getClassName();
        String time = LocalDateTime.ofInstant(Instant.now(), ZoneOffset.UTC).format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss"));
        this.csvReporterDirectory = Paths.get("benchmarks", "results", this.taskName, time).toFile();
        this.csvReporterDirectory.mkdirs();
    }

    public int nThreads() {
        return this.nThreads;
    }

    public Duration executionTaskTime() {
        return this.executionTaskTime;
    }

    public Duration reporterPeriod() {
        return this.reporterPeriod;
    }

    public File csvReporterDirectory() {
        return this.csvReporterDirectory;
    }

    public String taskName() {
        return this.taskName;
    }

    public String find(String key, String defValue) {
        return this.options.getOrDefault(key, defValue);
    }

    public MetricRegistry registry() {
        return this.registry;
    }

    public TimeUnit durationUnit() {
        return this.durationUnit;
    }

    public TimeUnit rateUnit() {
        return this.rateUnit;
    }

    public long numOfIterations() {
        return this.numOfIterations;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BenchmarksSettings{");
        sb.append("nThreads=").append(this.nThreads);
        sb.append(", executionTaskTime=").append(this.executionTaskTime);
        sb.append(", numOfIterations=").append(this.numOfIterations);
        sb.append(", reporterPeriod=").append(this.reporterPeriod);
        sb.append(", csvReporterDirectory=").append(this.csvReporterDirectory);
        sb.append(", taskName='").append(this.taskName).append('\'');
        sb.append(", durationUnit=").append((Object)this.durationUnit);
        sb.append(", rateUnit=").append((Object)this.rateUnit);
        sb.append(", registry=").append(this.registry);
        sb.append(", options=").append(this.options);
        sb.append('}');
        return sb.toString();
    }

    static /* synthetic */ int access$800() {
        return N_THREADS;
    }

    static /* synthetic */ Duration access$900() {
        return EXECUTION_TASK_TIME;
    }

    static /* synthetic */ Duration access$1000() {
        return REPORTER_PERIOD;
    }

    static /* synthetic */ TimeUnit access$1100() {
        return DURATION_UNIT;
    }

    static /* synthetic */ TimeUnit access$1200() {
        return RATE_UNIT;
    }

    public static class Builder {
        private final Map<String, String> options = new HashMap<String, String>();
        private int nThreads = BenchmarksSettings.access$800();
        private Duration executionTaskTime = BenchmarksSettings.access$900();
        private Duration reporterPeriod = BenchmarksSettings.access$1000();
        private TimeUnit durationUnit = BenchmarksSettings.access$1100();
        private TimeUnit rateUnit = BenchmarksSettings.access$1200();
        private long numOfIterations = Long.MAX_VALUE;

        public Builder from(String[] args) {
            this.parse(args);
            return this;
        }

        private Builder() {
        }

        public Builder nThreads(int numThreads) {
            this.nThreads = numThreads;
            return this;
        }

        public Builder executionTaskTime(Duration executionTaskTime) {
            this.executionTaskTime = executionTaskTime;
            return this;
        }

        public Builder reporterPeriod(Duration reporterPeriod) {
            this.reporterPeriod = reporterPeriod;
            return this;
        }

        public Builder addOption(String key, String value) {
            this.options.put(key, value);
            return this;
        }

        public Builder durationUnit(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder rateUnit(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder numOfIterations(long numOfIterations) {
            this.numOfIterations = numOfIterations;
            return this;
        }

        public BenchmarksSettings build() {
            return new BenchmarksSettings(this);
        }

        private void parse(String[] args) {
            if (args != null) {
                block12: for (String pair : args) {
                    String[] keyValue = pair.split("=", 2);
                    String key = keyValue[0];
                    String value = keyValue[1];
                    switch (key) {
                        case "nThreads": {
                            this.nThreads(Integer.parseInt(value));
                            continue block12;
                        }
                        case "executionTaskTimeInSec": {
                            this.executionTaskTime(Duration.ofSeconds(Long.parseLong(value)));
                            continue block12;
                        }
                        case "reporterPeriodInSec": {
                            this.reporterPeriod(Duration.ofSeconds(Long.parseLong(value)));
                            continue block12;
                        }
                        case "numOfIterations": {
                            this.numOfIterations(Long.parseLong(value));
                            continue block12;
                        }
                        default: {
                            this.addOption(key, value);
                        }
                    }
                }
            }
        }
    }
}

