/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.server;

import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.TransportHeaderAware;
import io.rsocket.transport.netty.server.NettyContextCloseable;
import io.rsocket.transport.netty.server.WebsocketRouteTransport;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.server.HttpServer;
import reactor.ipc.netty.http.server.HttpServerRequest;
import reactor.ipc.netty.http.server.HttpServerResponse;

public class WebsocketServerTransport
implements ServerTransport<NettyContextCloseable>,
TransportHeaderAware {
    HttpServer server;
    private Supplier<Map<String, String>> transportHeaders = Collections::emptyMap;

    private WebsocketServerTransport(HttpServer server) {
        this.server = server;
    }

    public static WebsocketServerTransport create(String bindAddress, int port) {
        HttpServer httpServer = HttpServer.create(bindAddress, port);
        return WebsocketServerTransport.create(httpServer);
    }

    public static WebsocketServerTransport create(int port) {
        HttpServer httpServer = HttpServer.create(port);
        return WebsocketServerTransport.create(httpServer);
    }

    public static WebsocketServerTransport create(HttpServer server) {
        return new WebsocketServerTransport(server);
    }

    @Override
    public Mono<NettyContextCloseable> start(ServerTransport.ConnectionAcceptor acceptor) {
        return this.server.newHandler((BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>>)((BiFunction<HttpServerRequest, HttpServerResponse, Publisher>)(request, response) -> {
            this.transportHeaders.get().forEach(response::addHeader);
            return response.sendWebsocket(WebsocketRouteTransport.newHandler(acceptor));
        })).map(NettyContextCloseable::new);
    }

    @Override
    public void setTransportHeaders(Supplier<Map<String, String>> transportHeaders) {
        this.transportHeaders = transportHeaders;
    }
}

