/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.ipc.netty.NettyConnector;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.channel.ChannelOperations;
import reactor.ipc.netty.channel.ContextHandler;
import reactor.ipc.netty.options.ClientOptions;
import reactor.ipc.netty.options.NettyOptions;
import reactor.ipc.netty.resources.PoolResources;
import reactor.ipc.netty.tcp.TcpResources;

public class TcpClient
implements NettyConnector<NettyInbound, NettyOutbound> {
    final ClientOptions options;
    protected static final ChannelOperations.OnNew<SocketChannel> EMPTY = (a, b, c) -> null;
    static final LoggingHandler loggingHandler = new LoggingHandler(TcpClient.class);

    public static TcpClient create() {
        return TcpClient.create(NetUtil.LOCALHOST.getHostAddress());
    }

    public static TcpClient create(String bindAddress) {
        return TcpClient.create(bindAddress, NettyOptions.DEFAULT_PORT);
    }

    public static TcpClient create(int port) {
        return TcpClient.create(NetUtil.LOCALHOST.getHostAddress(), port);
    }

    public static TcpClient create(String bindAddress, int port) {
        return TcpClient.create((? super ClientOptions.Builder<?> opts) -> ((ClientOptions.Builder)opts.host(bindAddress)).port(port));
    }

    public static TcpClient create(Consumer<? super ClientOptions.Builder<?>> options) {
        return TcpClient.builder().options(options).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected TcpClient(Builder builder) {
        ClientOptions.Builder clientOptionsBuilder = ClientOptions.builder();
        if (Objects.nonNull(builder.options)) {
            builder.options.accept(clientOptionsBuilder);
        }
        if (!clientOptionsBuilder.isLoopAvailable()) {
            clientOptionsBuilder.loopResources(TcpResources.get());
        }
        if (!clientOptionsBuilder.isPoolAvailable() && !clientOptionsBuilder.isPoolDisabled()) {
            clientOptionsBuilder.poolResources(TcpResources.get());
        }
        this.options = clientOptionsBuilder.build();
    }

    protected TcpClient(ClientOptions options) {
        this.options = Objects.requireNonNull(options, "options");
    }

    @Override
    public final Mono<? extends NettyContext> newHandler(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.newHandler(handler, null, true, null);
    }

    public final ClientOptions options() {
        return this.options.duplicate();
    }

    public String toString() {
        return "TcpClient: " + this.options.asSimpleString();
    }

    protected Mono<NettyContext> newHandler(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler, InetSocketAddress address, boolean secure, Consumer<? super Channel> onSetup) {
        BiFunction<Object, Object, Publisher<Void>> targetHandler = null == handler ? ChannelOperations.noopHandler() : handler;
        return Mono.create((MonoSink<T> sink) -> {
            InetSocketAddress remote = address != null ? address : this.options.getAddress();
            ChannelPool pool = null;
            PoolResources poolResources = this.options.getPoolResources();
            if (poolResources != null) {
                pool = poolResources.selectOrCreate(remote, this.options, this.doHandler(null, (MonoSink<NettyContext>)sink, secure, remote, null, null), this.options.getLoopResources().onClient(this.options.preferNative()));
            }
            ContextHandler<SocketChannel> contextHandler = this.doHandler((BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>>)targetHandler, (MonoSink<NettyContext>)sink, secure, remote, pool, onSetup);
            sink.onCancel(contextHandler);
            if (pool == null) {
                Bootstrap b = this.options.get();
                b.remoteAddress(remote);
                b.handler(contextHandler);
                contextHandler.setFuture(b.connect());
            } else {
                contextHandler.setFuture(pool.acquire());
            }
        });
    }

    protected ContextHandler<SocketChannel> doHandler(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler, MonoSink<NettyContext> sink, boolean secure, SocketAddress providedAddress, ChannelPool pool, Consumer<? super Channel> onSetup) {
        return ContextHandler.newClientContext(sink, this.options, loggingHandler, secure, providedAddress, pool, handler == null ? EMPTY : (ch, c, msg) -> ChannelOperations.bind(ch, handler, c));
    }

    public static final class Builder {
        private Consumer<? super ClientOptions.Builder<?>> options;

        private Builder() {
        }

        public final Builder options(Consumer<? super ClientOptions.Builder<?>> options) {
            this.options = Objects.requireNonNull(options, "options");
            return this;
        }

        public TcpClient build() {
            return new TcpClient(this);
        }
    }
}

