/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Objects;
import java.util.function.Function;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import reactor.ipc.netty.options.ClientOptions;
import reactor.ipc.netty.options.ClientProxyOptions;
import reactor.util.function.Tuple2;

public final class HttpClientOptions
extends ClientOptions {
    private final boolean acceptGzip;
    static final SslContext DEFAULT_SSL_CONTEXT;

    public static Builder builder() {
        return new Builder();
    }

    private HttpClientOptions(Builder builder) {
        super(builder);
        this.acceptGzip = builder.acceptGzip;
    }

    @Override
    public HttpClientOptions duplicate() {
        return HttpClientOptions.builder().from(this).build();
    }

    public final InetSocketAddress getRemoteAddress(URI uri) {
        Objects.requireNonNull(uri, "uri");
        boolean secure = HttpClientOptions.isSecure(uri);
        int port = uri.getPort() != -1 ? uri.getPort() : (secure ? 443 : 80);
        boolean shouldResolveAddress = !this.useProxy(uri.getHost());
        return this.createInetSocketAddress(uri.getHost(), port, shouldResolveAddress);
    }

    @Override
    public SslHandler getSslHandler(ByteBufAllocator allocator, Tuple2<String, Integer> sniInfo) {
        SslHandler handler = super.getSslHandler(allocator, sniInfo);
        SSLEngine sslEngine = handler.engine();
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        sslEngine.setSSLParameters(sslParameters);
        return handler;
    }

    public boolean acceptGzip() {
        return this.acceptGzip;
    }

    @Override
    protected SslContext defaultSslContext() {
        return DEFAULT_SSL_CONTEXT;
    }

    final String formatSchemeAndHost(String url, boolean ws) {
        if (!url.startsWith("http") && !url.startsWith("ws")) {
            StringBuilder schemeBuilder = new StringBuilder();
            if (ws) {
                schemeBuilder.append(this.isSecure() ? "wss" : "ws");
            } else {
                schemeBuilder.append(this.isSecure() ? "https" : "http");
            }
            String scheme = schemeBuilder.append("://").toString();
            if (url.startsWith("/")) {
                SocketAddress remote = this.getAddress();
                if (remote instanceof InetSocketAddress) {
                    return scheme + NetUtil.toSocketAddressString((InetSocketAddress)remote) + url;
                }
                return scheme + "localhost" + url;
            }
            return scheme + url;
        }
        return url;
    }

    @Override
    public String asSimpleString() {
        return super.asSimpleString() + (this.acceptGzip ? " with gzip" : "");
    }

    @Override
    public String asDetailedString() {
        return super.asDetailedString() + ", acceptGzip=" + this.acceptGzip;
    }

    @Override
    public String toString() {
        return "HttpClientOptions{" + this.asDetailedString() + "}";
    }

    static boolean isSecure(URI uri) {
        return uri.getScheme() != null && (uri.getScheme().toLowerCase().equals("https") || uri.getScheme().toLowerCase().equals("wss"));
    }

    static {
        SslContext sslContext;
        try {
            sslContext = SslContextBuilder.forClient().build();
        }
        catch (Exception e) {
            sslContext = null;
        }
        DEFAULT_SSL_CONTEXT = sslContext;
    }

    public static final class Builder
    extends ClientOptions.Builder<Builder> {
        private boolean acceptGzip;

        private Builder() {
            super(new Bootstrap());
        }

        public final Builder compression(boolean enabled) {
            this.acceptGzip = enabled;
            return (Builder)this.get();
        }

        public final Builder httpProxy(Function<ClientProxyOptions.AddressSpec, ClientProxyOptions.Builder> proxyOptions) {
            super.proxy(t -> (ClientProxyOptions.Builder)proxyOptions.apply(t.type(ClientProxyOptions.Proxy.HTTP)));
            return (Builder)this.get();
        }

        @Override
        public final Builder from(HttpClientOptions options) {
            super.from(options);
            this.acceptGzip = options.acceptGzip;
            return (Builder)this.get();
        }

        @Override
        public HttpClientOptions build() {
            super.build();
            return new HttpClientOptions(this);
        }
    }
}

