/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import java.util.concurrent.ThreadLocalRandom;

public final class NetworkLinkSettings {
    private final int lossPercent;
    private final int meanDelay;

    public NetworkLinkSettings(int lossPercent, int mean) {
        this.lossPercent = lossPercent;
        this.meanDelay = mean;
    }

    public int lossPercent() {
        return this.lossPercent;
    }

    public int meanDelay() {
        return this.meanDelay;
    }

    public boolean evaluateLoss() {
        return this.lossPercent > 0 && (this.lossPercent >= 100 || ThreadLocalRandom.current().nextInt(100) < this.lossPercent);
    }

    public long evaluateDelay() {
        if (this.meanDelay > 0) {
            Double x0 = ThreadLocalRandom.current().nextDouble();
            Double y0 = -Math.log(1.0 - x0) * (double)this.meanDelay;
            return y0.longValue();
        }
        return 0L;
    }

    public String toString() {
        return "NetworkLinkSettings{lossPercent=" + this.lossPercent + ", meanDelay=" + this.meanDelay + '}';
    }
}

