/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import io.scalecube.Strings;
import io.scalecube.Throwables;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public final class Addressing {
    public static final int MIN_PORT_NUMBER = 1100;
    public static final int MAX_PORT_NUMBER = 65535;

    private Addressing() {
    }

    public static InetAddress getLocalIpAddress(String listenAddress, String listenInterface, boolean preferIPv6) {
        InetAddress ipAddress;
        if (!Strings.isNullOrEmpty(listenAddress) && !Strings.isNullOrEmpty(listenInterface)) {
            throw new IllegalArgumentException("Not allowed to set both listenAddress and listenInterface, choose one");
        }
        if (!Strings.isNullOrEmpty(listenAddress)) {
            try {
                ipAddress = InetAddress.getByName(listenAddress);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Unknown listenAddress: " + listenAddress);
            }
            if (ipAddress.isAnyLocalAddress()) {
                throw new IllegalArgumentException("listenAddress: " + listenAddress + " cannot be a wildcard address");
            }
            if (!Addressing.isValidLocalIpAddress(ipAddress)) {
                throw new IllegalArgumentException("listenAddress: " + listenAddress + " doesn't belong to any active network interface");
            }
        } else {
            ipAddress = !Strings.isNullOrEmpty(listenInterface) ? Addressing.getNetworkInterfaceIpAddress(listenInterface, preferIPv6) : Addressing.getLocalIpAddress();
        }
        return ipAddress;
    }

    public static InetAddress getLocalIpAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate(e);
        }
    }

    private static InetAddress getNetworkInterfaceIpAddress(String listenInterface, boolean preferIPv6) {
        try {
            NetworkInterface ni = NetworkInterface.getByName(listenInterface);
            if (ni == null) {
                throw new IllegalArgumentException("Configured network interface: " + listenInterface + " could not be found");
            }
            if (!ni.isUp()) {
                throw new IllegalArgumentException("Configured network interface: " + listenInterface + " is not active");
            }
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            if (!addrs.hasMoreElements()) {
                throw new IllegalArgumentException("Configured network interface: " + listenInterface + " was found, but had no addresses");
            }
            InetAddress result = null;
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if (preferIPv6 && addr instanceof Inet6Address) {
                    return addr;
                }
                if (!preferIPv6 && addr instanceof Inet4Address) {
                    return addr;
                }
                if (result != null) continue;
                result = addr;
            }
            return result;
        }
        catch (SocketException e) {
            throw new IllegalArgumentException("Configured network interface: " + listenInterface + " caused an exception", e);
        }
    }

    private static boolean isValidLocalIpAddress(InetAddress listenAddress) {
        ArrayList<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
        }
        catch (SocketException e) {
            throw new IllegalArgumentException("Can't get list of network interfaces", e);
        }
        for (NetworkInterface ni : networkInterfaces) {
            try {
                if (!ni.isUp()) continue;
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!addr.getHostAddress().equals(listenAddress.getHostAddress())) continue;
                    return true;
                }
            }
            catch (SocketException e) {
                throw new IllegalArgumentException("Network interface: " + ni + " caused an exception", e);
            }
        }
        return false;
    }
}

