/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.transport.rsocket;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.rsocket.RSocketFactory;
import io.rsocket.transport.netty.server.NettyContextCloseable;
import io.rsocket.transport.netty.server.TcpServerTransport;
import io.rsocket.util.ByteBufPayload;
import io.scalecube.services.codec.ServiceMessageCodec;
import io.scalecube.services.methods.ServiceMethodRegistry;
import io.scalecube.services.transport.api.ServerTransport;
import io.scalecube.services.transport.rsocket.DelegatedLoopResources;
import io.scalecube.services.transport.rsocket.RSocketServiceAcceptor;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.FutureMono;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.options.NettyOptions;
import reactor.ipc.netty.options.ServerOptions;
import reactor.ipc.netty.tcp.TcpServer;

public class RSocketServerTransport
implements ServerTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(RSocketServerTransport.class);
    private static final int BOSS_THREADS_NUM = 1;
    private static final DefaultThreadFactory BOSS_THREAD_FACTORY = new DefaultThreadFactory("rsocket-boss", true);
    private final ServiceMessageCodec codec;
    private final EventLoopGroup bossGroup;
    private final DelegatedLoopResources loopResources;
    private NettyContextCloseable server;
    private List<NettyContext> channels = new CopyOnWriteArrayList<NettyContext>();

    public RSocketServerTransport(ServiceMessageCodec codec, boolean preferEpoll, EventLoopGroup eventLoopGroup) {
        this.codec = codec;
        this.bossGroup = preferEpoll ? new EpollEventLoopGroup(1, BOSS_THREAD_FACTORY) : new NioEventLoopGroup(1, BOSS_THREAD_FACTORY);
        this.loopResources = new DelegatedLoopResources(preferEpoll, this.bossGroup, eventLoopGroup);
    }

    @Override
    public InetSocketAddress bindAwait(InetSocketAddress address, ServiceMethodRegistry methodRegistry) {
        TcpServer tcpServer = TcpServer.create(options -> {
            ServerOptions.Builder cfr_ignored_0 = (ServerOptions.Builder)((NettyOptions.Builder)((ServerOptions.Builder)options.loopResources(this.loopResources)).listenAddress(address)).afterNettyContextInit(nettyContext -> {
                LOGGER.info("Accepted connection on {}", (Object)nettyContext.channel());
                nettyContext.onClose(() -> {
                    LOGGER.info("Connection closed on {}", (Object)nettyContext.channel());
                    this.channels.remove(nettyContext);
                });
                this.channels.add((NettyContext)nettyContext);
            });
        });
        this.server = RSocketFactory.receive().frameDecoder(frame -> ByteBufPayload.create(frame.sliceData().retain(), frame.sliceMetadata().retain())).acceptor(new RSocketServiceAcceptor(this.codec, methodRegistry)).transport(TcpServerTransport.create(tcpServer)).start().block();
        return this.server.address();
    }

    @Override
    public Mono<Void> stop() {
        return Mono.defer(() -> {
            ArrayList<Mono<Void>> stopList = new ArrayList<Mono<Void>>();
            stopList.add(FutureMono.from(this.bossGroup.shutdownGracefully()));
            this.channels.stream().collect(() -> stopList, (list, context) -> {
                context.dispose();
                list.add(context.onClose());
            }, (monos1, monos2) -> {});
            if (this.server != null) {
                this.server.dispose();
                stopList.add(this.server.onClose());
            }
            return Mono.when(stopList);
        });
    }
}

