/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.transport.rsocket;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.SelectStrategy;
import io.netty.channel.SelectStrategyFactory;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.scalecube.services.transport.rsocket.EventExecutorChooser;
import java.lang.reflect.Constructor;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

public class ExtendedNioEventLoopGroup
extends NioEventLoopGroup {
    private final EventExecutorChooser eventExecutorChooser;

    public ExtendedNioEventLoopGroup(int numOfThreads, ThreadFactory threadFactory, EventExecutorChooser eventExecutorChooser) {
        super(numOfThreads, threadFactory);
        this.eventExecutorChooser = eventExecutorChooser;
    }

    @Override
    protected EventLoop newChild(Executor executor, Object ... args) throws Exception {
        Class<?> eventLoopClass = Class.forName("io.netty.channel.nio.NioEventLoop");
        Constructor<?> constructor = eventLoopClass.getDeclaredConstructor(NioEventLoopGroup.class, Executor.class, SelectorProvider.class, SelectStrategy.class, RejectedExecutionHandler.class);
        constructor.setAccessible(true);
        return (EventLoop)constructor.newInstance(this, executor, (SelectorProvider)args[0], ((SelectStrategyFactory)args[1]).newSelectStrategy(), (RejectedExecutionHandler)args[2]);
    }

    @Override
    public ChannelFuture register(Channel channel) {
        EventExecutor eventExecutor = this.eventExecutorChooser.getEventExecutor(channel, this.iterator());
        return eventExecutor != null ? ((EventLoop)eventExecutor).register(channel) : super.register(channel);
    }

    @Override
    public ChannelFuture register(ChannelPromise promise) {
        return this.register(promise.channel());
    }
}

