/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.transport.rsocket;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.resources.LoopResources;

public class DelegatedLoopResources
implements LoopResources {
    private final boolean preferEpoll;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final AtomicBoolean running = new AtomicBoolean(true);

    public DelegatedLoopResources(boolean preferEpoll, EventLoopGroup workerGroup) {
        this(preferEpoll, null, workerGroup);
    }

    public DelegatedLoopResources(boolean preferEpoll, EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        this.preferEpoll = preferEpoll;
        this.bossGroup = bossGroup;
        this.workerGroup = workerGroup;
    }

    @Override
    public EventLoopGroup onClient(boolean useNative) {
        return this.workerGroup;
    }

    @Override
    public EventLoopGroup onServer(boolean useNative) {
        return this.workerGroup;
    }

    @Override
    public EventLoopGroup onServerSelect(boolean useNative) {
        return this.bossGroup;
    }

    @Override
    public Class<? extends Channel> onChannel(EventLoopGroup group) {
        return this.preferEpoll ? EpollSocketChannel.class : NioSocketChannel.class;
    }

    @Override
    public Class<? extends DatagramChannel> onDatagramChannel(EventLoopGroup group) {
        return this.preferEpoll ? EpollDatagramChannel.class : NioDatagramChannel.class;
    }

    @Override
    public Class<? extends ServerChannel> onServerChannel(EventLoopGroup group) {
        return this.preferEpoll ? EpollServerSocketChannel.class : NioServerSocketChannel.class;
    }

    @Override
    public boolean preferNative() {
        return this.preferEpoll;
    }

    @Override
    public boolean daemon() {
        return true;
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isDisposed() {
        return !this.running.get();
    }

    @Override
    public Mono<Void> disposeLater() {
        return Mono.defer(() -> {
            this.running.compareAndSet(true, false);
            return Mono.empty();
        });
    }
}

